/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.tracker;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public final class ChatMessage {
    public static final Class<?> CRAFT_CHAT_MESSAGE;
    public static final Class<?> CHAT_BASE_COMPONENT;
    private static final Method MESSAGE_FROM_STRING;
    private static Method MESSAGE_FROM_JSON;

    private ChatMessage() throws IllegalAccessException {
        throw new IllegalAccessException(this.getClass().getSimpleName() + " cannot be instantiated.");
    }

    @NotNull
    public static Object fromString(String message) {
        try {
            return Array.get(MESSAGE_FROM_STRING.invoke(null, message), 0);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static Object legacyTextComponent(String message) {
        if (MESSAGE_FROM_JSON == null) {
            return ChatMessage.fromString(message);
        }
        StringBuilder builder = new StringBuilder("{\"text\":\"");
        for (char c : message.toCharArray()) {
            if (c == '\"') {
                builder.append('\\');
            }
            builder.append(c);
        }
        builder.append("\"}");
        return ChatMessage.legacyTextComponentString(builder.toString());
    }

    @NotNull
    public static Object legacyTextComponentString(String message) {
        if (MESSAGE_FROM_JSON == null) {
            return ChatMessage.fromString(message);
        }
        try {
            return MESSAGE_FROM_JSON.invoke(null, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            CRAFT_CHAT_MESSAGE = NMSUtils.obcClass("util.CraftChatMessage");
            MESSAGE_FROM_STRING = CRAFT_CHAT_MESSAGE.getMethod("fromString", String.class);
            CHAT_BASE_COMPONENT = NMSUtils.nmsClass("network.chat", "IChatBaseComponent", "Component");
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        try {
            Class<?>[] innerClasses = CHAT_BASE_COMPONENT.getDeclaredClasses();
            if (innerClasses.length == 0) {
                throw new NoSuchMethodException();
            }
            Class<?> serializer = innerClasses[0];
            MESSAGE_FROM_JSON = NMSUtils.getMethod(serializer, CHAT_BASE_COMPONENT, String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

