/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.tracker;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fallenkingdom.version.tracker.TrackedDataHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class DataTracker {
    private static final Class<?> TRACKED_DATA_TYPE;
    private static final Constructor<?> TRACKED_DATA;
    @Nullable
    private static final Method SERIALIZE_TRACKED_DATA;
    private static final Class<?> TRACKED_ENTRY_TYPE;
    private static final Constructor<?> TRACKED_ENTRY;
    private final List<Object> trackedValues = new ArrayList<Object>(5);

    @Contract(value="-> this")
    public DataTracker invisible() {
        this.track(0, TrackedDataHandler.BYTE, (byte)32);
        return this;
    }

    @Contract(value="_ -> this")
    public DataTracker customName(@Nullable String customName) {
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            this.track(2, TrackedDataHandler.OPT_COMPONENT_FROM_STRING, Optional.ofNullable(customName));
        } else {
            this.track(2, TrackedDataHandler.STRING, customName);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public DataTracker customNameVisible(boolean visible) {
        this.track(3, TrackedDataHandler.BOOLEAN, visible);
        return this;
    }

    @Contract(value="_ -> this")
    public DataTracker silent(boolean silent) {
        this.track(4, TrackedDataHandler.BOOLEAN, silent);
        return this;
    }

    private <T> void track(int index, TrackedDataHandler<T> handler, T value) {
        try {
            this.trackedValues.add(TRACKED_ENTRY.newInstance(TRACKED_DATA.newInstance(index, handler.delegate()), handler.map(value)));
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    public List<Object> trackedValues() {
        return this.trackedValues;
    }

    public List<Object> serializedTrackedValues() {
        if (SERIALIZE_TRACKED_DATA == null) {
            return this.trackedValues;
        }
        return this.trackedValues.stream().map(value -> {
            try {
                return SERIALIZE_TRACKED_DATA.invoke(value, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    static {
        try {
            String package1_17 = "network.syncher";
            TRACKED_DATA_TYPE = NMSUtils.nmsClass(package1_17, "DataWatcherObject", "EntityDataAccessor");
            TRACKED_DATA = TRACKED_DATA_TYPE.getConstructor(Integer.TYPE, TrackedDataHandler.HANDLER_TYPE);
            TRACKED_ENTRY_TYPE = NMSUtils.nmsClass(package1_17, "DataWatcher$Item", "SynchedEntityData$DataItem");
            TRACKED_ENTRY = TRACKED_ENTRY_TYPE.getConstructor(TRACKED_DATA_TYPE, Object.class);
            Method serialize = null;
            try {
                Class<?> serializedTypeOpt = NMSUtils.nmsOptionalClass(package1_17, "DataWatcher$c", "SynchedEntityData$DataValue").orElse(null);
                if (serializedTypeOpt == null) {
                    serializedTypeOpt = NMSUtils.nmsClass(package1_17, "DataWatcher$b");
                }
                Class<?> serializedType = serializedTypeOpt;
                serialize = Arrays.stream(TRACKED_ENTRY_TYPE.getMethods()).filter(method -> method.getParameterCount() == 0 && serializedType.equals(method.getReturnType())).findFirst().orElseThrow(NoSuchMethodException::new);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            SERIALIZE_TRACKED_DATA = serialize;
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

