/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fallenkingdom.version.tracker;

import fr.devsylone.fallenkingdom.utils.NMSUtils;
import fr.devsylone.fallenkingdom.version.tracker.ChatMessage;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TrackedDataHandler<T> {
    static final Class<?> HANDLER_TYPE;
    private static final Field[] HANDLERS;
    static final TrackedDataHandler<Byte> BYTE;
    static final TrackedDataHandler<Boolean> BOOLEAN;
    static final TrackedDataHandler<String> STRING;
    static final TrackedDataHandler<Optional<String>> OPT_COMPONENT_FROM_STRING;
    private final Object delegate;
    private final Function<T, Object> mapper;

    private TrackedDataHandler(Object delegate, Function<T, Object> mapper) {
        this.delegate = delegate;
        this.mapper = mapper;
    }

    @NotNull
    static <T> TrackedDataHandler<T> need(Class<T> type) {
        return TrackedDataHandler.need(type, Function.identity());
    }

    @NotNull
    static <T, U> TrackedDataHandler<T> need(Class<U> type, Function<T, U> mapper) {
        TrackedDataHandler<T> handler = TrackedDataHandler.find(type, mapper);
        if (handler == null) {
            throw new HookFailed(type.getSimpleName());
        }
        return handler;
    }

    @NotNull
    static <T, U> TrackedDataHandler<Optional<T>> needOptional(Class<U> optionalType, Function<T, U> mapper) {
        TrackedDataHandler<Optional<T>> handler = TrackedDataHandler.findOptional(optionalType, mapper);
        if (handler == null) {
            throw new HookFailed("Optional<" + optionalType.getSimpleName() + '>');
        }
        return handler;
    }

    @Nullable
    static <T> TrackedDataHandler<T> find(Class<T> type) {
        return TrackedDataHandler.find(type, Function.identity());
    }

    @Nullable
    static <T, U> TrackedDataHandler<T> find(Class<U> type, Function<T, U> mapper) {
        for (Field field : HANDLERS) {
            Type serializerType = TrackedDataHandler.serializerType(field);
            if (serializerType == null || serializerType instanceof ParameterizedType || !((Class)serializerType).isAssignableFrom(type)) continue;
            try {
                return new TrackedDataHandler<T>(field.get(null), mapper);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    static <T> TrackedDataHandler<Optional<T>> findOptional(Class<T> optionalType) {
        return TrackedDataHandler.findOptional(optionalType, Function.identity());
    }

    @Nullable
    static <T, U> TrackedDataHandler<Optional<T>> findOptional(Class<U> optionalType, Function<T, U> mapper) {
        for (Field field : HANDLERS) {
            Type serializerType = TrackedDataHandler.serializerType(field);
            if (!(serializerType instanceof ParameterizedType) || !TrackedDataHandler.genericType(serializerType).isAssignableFrom(optionalType)) continue;
            try {
                return new TrackedDataHandler<Optional<T>>(field.get(null), opt -> opt.map(mapper));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static Type serializerType(Field field) {
        Type fieldType = field.getGenericType();
        if (!(fieldType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)fieldType;
        return pType.getActualTypeArguments()[0];
    }

    private static Class<?> genericType(Type genericType) {
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }

    Object delegate() {
        return this.delegate;
    }

    Object map(T value) {
        return this.mapper.apply(value);
    }

    static {
        try {
            String package1_17 = "network.syncher";
            HANDLER_TYPE = NMSUtils.nmsClass(package1_17, "DataWatcherSerializer", "EntityDataSerializer");
            HANDLERS = NMSUtils.nmsClass(package1_17, "DataWatcherRegistry", "EntityDataSerializers").getFields();
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        BYTE = TrackedDataHandler.need(Byte.class);
        BOOLEAN = TrackedDataHandler.need(Boolean.class);
        STRING = TrackedDataHandler.need(String.class);
        OPT_COMPONENT_FROM_STRING = TrackedDataHandler.findOptional(ChatMessage.CHAT_BASE_COMPONENT, ChatMessage::fromString);
    }

    private static class HookFailed
    extends RuntimeException {
        private static final long serialVersionUID = 8123977838158944863L;

        HookFailed(String type) {
            super("Unable to match a handler with the " + type + " type.");
        }
    }
}

