/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi;

import fr.devsylone.fkpi.managers.ChestsRoomsManager;
import fr.devsylone.fkpi.managers.LockedChestsManager;
import fr.devsylone.fkpi.managers.RulesManager;
import fr.devsylone.fkpi.managers.TeamManager;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class FkPI
implements Saveable {
    private TeamManager teamManager = new TeamManager();
    private RulesManager rulesManager = new RulesManager();
    private LockedChestsManager lockedChestsManager = new LockedChestsManager();
    private ChestsRoomsManager chestsRoomsManager = new ChestsRoomsManager();
    private static FkPI instance;

    public static FkPI getInstance() {
        return instance;
    }

    public FkPI() {
        instance = this;
    }

    @NotNull
    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    @NotNull
    public RulesManager getRulesManager() {
        return this.rulesManager;
    }

    @NotNull
    public LockedChestsManager getLockedChestsManager() {
        return this.lockedChestsManager;
    }

    @NotNull
    public ChestsRoomsManager getChestsRoomsManager() {
        return this.chestsRoomsManager;
    }

    public void reset() {
        this.teardown();
        for (Team team : this.teamManager.getTeams()) {
            if (team.getBase() == null) continue;
            team.getBase().getNexus().remove();
        }
        this.teamManager = new TeamManager();
        this.rulesManager = new RulesManager();
        this.lockedChestsManager = new LockedChestsManager();
        this.chestsRoomsManager = new ChestsRoomsManager();
    }

    public void teardown() {
        this.teamManager.teardown();
    }

    @Override
    public void load(ConfigurationSection config) {
        this.chestsRoomsManager.loadNullable(config.getConfigurationSection("ChestsRoomsManager"));
        this.rulesManager.loadNullable(config.getConfigurationSection("RulesManager"));
        this.teamManager.loadNullable(config.getConfigurationSection("TeamManager"));
        this.lockedChestsManager.loadNullable(config.getConfigurationSection("LockedChestsManager"));
    }

    @Override
    public void loadNullable(ConfigurationSection config) {
        this.load(config);
    }

    @Override
    public void save(ConfigurationSection config) {
        this.rulesManager.save(config.createSection("RulesManager"));
        this.teamManager.save(config.createSection("TeamManager"));
        this.lockedChestsManager.save(config.createSection("LockedChestsManager"));
        this.chestsRoomsManager.save(config.createSection("ChestsRoomsManager"));
    }
}

