/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.lockedchests;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.progress.ProgressBar;
import fr.devsylone.fallenkingdom.utils.KeyHelper;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XAdvancement;
import fr.devsylone.fallenkingdom.version.Version;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.event.PlayerLockedChestInteractEvent;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;

public class LockedChest
implements Saveable {
    private UUID unlocker;
    private ChatColor chatColor = ChatColor.RESET;
    private Location loc;
    private int day;
    private ChestState state = ChestState.LOCKED;
    private long time;
    private long lastInteract;
    private long startUnlocking;
    private float yFix = -0.5f;
    private String requiredAdvancement;
    private String lootTable;
    private int task = -1;
    private String name;

    public LockedChest(Location loc, int timeSecs, int day, String name) {
        this.loc = loc;
        this.time = (long)timeSecs * 1000L;
        this.day = day;
        this.lastInteract = System.currentTimeMillis();
        this.name = name;
    }

    public Location getLocation() {
        return this.loc.clone();
    }

    public UUID getUnlocker() {
        return this.unlocker;
    }

    public int getUnlockDay() {
        return this.day;
    }

    @Deprecated
    public int getUnlockingTime() {
        return this.getUnlockingTimeSecs();
    }

    public int getUnlockingTimeSecs() {
        return (int)(this.time / 1000L);
    }

    public long getUnlockingTimeMillis() {
        return this.time;
    }

    public String getName() {
        return this.name;
    }

    public void changeUnlocker(Player newPlayer) {
        this.unlocker = newPlayer == null ? null : newPlayer.getUniqueId();
        this.startUnlocking = System.currentTimeMillis();
        if (newPlayer == null) {
            this.setState(ChestState.LOCKED);
        } else {
            this.setState(ChestState.UNLOCKING);
        }
        Team team = FkPI.getInstance().getTeamManager().getPlayerTeam(newPlayer);
        this.chatColor = team == null ? ChatColor.RESET : team.getChatColor();
    }

    public ChestState getState() {
        return this.state;
    }

    public void setState(ChestState state) {
        this.state = state;
    }

    public void updateLastInteract() {
        this.lastInteract = System.currentTimeMillis();
    }

    public void setYFixByBlockFace(BlockFace blockFace) {
        switch (blockFace) {
            case UP: {
                this.yFix = -1.25f;
                break;
            }
            case DOWN: {
                this.yFix = 0.0f;
                break;
            }
            default: {
                this.yFix = -0.5f;
            }
        }
    }

    public void startUnlocking(Player player) {
        PlayerLockedChestInteractEvent event = new PlayerLockedChestInteractEvent(player, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.unlocker != null) {
            Fk.broadcast(Messages.BROADCAST_LOCKED_CHEST_ABORT.getMessage().replace("%name%", this.name).replace("%player%", this.chatColor.toString() + Bukkit.getOfflinePlayer((UUID)this.unlocker).getName()));
        }
        this.changeUnlocker(player);
        Fk.broadcast(Messages.BROADCAST_LOCKED_CHEST_START.getMessage().replace("%name%", this.name).replace("%player%", this.chatColor + player.getName()));
        if (this.task > 0) {
            Bukkit.getScheduler().cancelTask(this.task);
        }
        this.lastInteract = System.currentTimeMillis();
        Location loc = this.loc.clone().add(0.5, (double)this.yFix, 0.5);
        ProgressBar bar = Fk.getInstance().getDisplayService().initProgressBar(player, loc);
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)Fk.getInstance(), () -> {
            double progress = (double)(System.currentTimeMillis() - this.startUnlocking) / (double)this.time;
            loc.setY(this.loc.getY() + (double)this.yFix);
            if (player.isOnline()) {
                bar.progress(player, loc, progress);
            }
            if (this.lastInteract + 1000L < System.currentTimeMillis()) {
                if (!this.getState().equals((Object)ChestState.UNLOCKED)) {
                    Fk.broadcast(Messages.BROADCAST_LOCKED_CHEST_ABORT.getMessage().replace("%name%", this.name).replace("%player%", this.chatColor + player.getName()));
                }
                Bukkit.getScheduler().cancelTask(this.task);
                this.changeUnlocker(null);
                if (player.isOnline()) {
                    bar.remove(player);
                }
            }
            if (this.startUnlocking + this.time <= System.currentTimeMillis()) {
                PlayerLockedChestInteractEvent endEvent = new PlayerLockedChestInteractEvent(player, this);
                Bukkit.getPluginManager().callEvent((Event)endEvent);
                if (!endEvent.isCancelled()) {
                    this.setState(ChestState.UNLOCKED);
                    Fk.broadcast(Messages.BROADCAST_LOCKED_CHEST_UNLOCKED.getMessage().replace("%name%", this.name).replace("%player%", this.chatColor + player.getName()));
                }
                Bukkit.getScheduler().cancelTask(this.task);
                if (player.isOnline()) {
                    bar.remove(player);
                }
            }
        }, 1L, 1L).getTaskId();
    }

    @Override
    public void load(ConfigurationSection config) {
        this.loc = new Location(Bukkit.getWorld((String)config.getString("Loc.World")), (double)config.getInt("Loc.x"), (double)config.getInt("Loc.y"), (double)config.getInt("Loc.z"));
        this.state = ChestState.valueOf(config.getString("State"));
        this.time = (long)config.getInt("Time") * 1000L;
        this.day = config.getInt("Day");
        this.name = config.getString("Name");
        this.lootTable = config.getString("LootTable");
        this.requiredAdvancement = config.getString("Advancement");
    }

    public Advancement getRequiredAdvancement() {
        if (this.requiredAdvancement == null || this.requiredAdvancement.isEmpty()) {
            return null;
        }
        return Bukkit.getAdvancement((NamespacedKey)KeyHelper.parseKey(this.requiredAdvancement));
    }

    public void setRequiredAdvancement(String advancement) {
        this.requiredAdvancement = advancement;
    }

    public boolean hasAccess(Player player) {
        if (this.requiredAdvancement == null || this.requiredAdvancement.isEmpty()) {
            return true;
        }
        return XAdvancement.hasAdvancement(player, this.requiredAdvancement);
    }

    public LootTable getLootTable() {
        if (this.lootTable == null || this.lootTable.isEmpty()) {
            return null;
        }
        if (Version.VersionType.V1_13.isHigherOrEqual()) {
            return Bukkit.getLootTable((NamespacedKey)KeyHelper.parseKey(this.lootTable));
        }
        throw new UnsupportedOperationException("Loot tables api don't exist in versions prior to 1.13.");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("Loc.World", (Object)this.loc.getWorld().getName());
        config.set("Loc.x", (Object)this.loc.getBlockX());
        config.set("Loc.y", (Object)this.loc.getBlockY());
        config.set("Loc.z", (Object)this.loc.getBlockZ());
        config.set("State", (Object)this.state.name());
        config.set("Time", (Object)this.getUnlockingTimeSecs());
        config.set("Day", (Object)this.day);
        config.set("Name", (Object)this.name);
        config.set("LootTable", (Object)this.lootTable);
        config.set("Advancement", (Object)this.requiredAdvancement);
    }

    public String toString() {
        return (this.unlocker == null ? "" : this.unlocker) + " / " + this.loc.getBlockX() + "|" + this.loc.getBlockY() + "|" + this.loc.getBlockZ() + " / " + this.time + " / " + this.day + " / " + this.state.name() + " / " + this.lastInteract + " / " + this.startUnlocking;
    }

    public static enum ChestState {
        LOCKED,
        UNLOCKING,
        UNLOCKED;

    }
}

