/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.managers;

import fr.devsylone.fkpi.util.Saveable;
import org.bukkit.configuration.ConfigurationSection;

public class ChestsRoomsManager
implements Saveable {
    private int captureTime = 60;
    private int coreHealth = 500;
    private int regenerationPerMinute = 20;
    private int regenerationPerMinutePerAlly = 10;
    private int offset = 2;
    private boolean enabled = true;

    public int getCaptureTime() {
        return this.captureTime;
    }

    public int getCoreHealth() {
        return this.coreHealth;
    }

    public int getRegenerationPerMinute() {
        return this.regenerationPerMinute;
    }

    public int getRegenerationPerMinutePerAlly() {
        return this.regenerationPerMinutePerAlly;
    }

    public int getRegenerationForTicks(int ticks, int allies) {
        return ticks * (this.regenerationPerMinute + allies * this.regenerationPerMinutePerAlly) / 1200;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCaptureTime(int arg) {
        this.captureTime = arg;
    }

    public void setCoreHealth(int coreHealth) {
        this.coreHealth = coreHealth;
    }

    public void setRegenerationPerMinute(int regenerationPerMinute) {
        this.regenerationPerMinute = regenerationPerMinute;
    }

    public void setRegenerationPerMinutePerAlly(int regenerationPerMinutePerAlly) {
        this.regenerationPerMinutePerAlly = regenerationPerMinutePerAlly;
    }

    public void setOffset(int arg) {
        this.offset = arg;
    }

    public void setEnabled(boolean arg) {
        this.enabled = arg;
    }

    @Override
    public void load(ConfigurationSection config) {
        this.captureTime = config.getInt("CaptureTime", 60);
        this.coreHealth = config.getInt("CoreHealth", 500);
        this.regenerationPerMinute = config.getInt("RegenerationPerMinute", 20);
        this.regenerationPerMinutePerAlly = config.getInt("RegenerationPerMinutePerAlly", 10);
        this.offset = config.getInt("Offset", 2);
        this.enabled = config.getBoolean("Enabled", true);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("CaptureTime", (Object)this.captureTime);
        config.set("CoreHealth", (Object)this.coreHealth);
        config.set("RegenerationPerMinute", (Object)this.regenerationPerMinute);
        config.set("RegenerationPerMinutePerAlly", (Object)this.regenerationPerMinutePerAlly);
        config.set("Offset", (Object)this.offset);
        config.set("Enabled", (Object)this.enabled);
    }
}

