/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.managers;

import fr.devsylone.fkpi.lockedchests.LockedChest;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockedChestsManager
implements Saveable {
    private final Map<Location, LockedChest> chests = new HashMap<Location, LockedChest>();

    public void addOrEdit(@NotNull LockedChest chest) {
        this.chests.put(chest.getLocation(), chest);
    }

    @Nullable
    public LockedChest getChestAt(@NotNull Location loc) {
        return this.chests.get(loc);
    }

    public boolean remove(@NotNull Location loc) {
        return this.chests.remove(loc) != null;
    }

    @NotNull
    public List<LockedChest> getChestList() {
        return new ArrayList<LockedChest>(this.chests.values());
    }

    @NotNull
    public Collection<LockedChest> getChests() {
        return this.chests.values();
    }

    @NotNull
    public Map<Location, LockedChest> getChestMap() {
        return this.chests;
    }

    @Override
    public void load(ConfigurationSection config) {
        if (config.isConfigurationSection("LockedChests")) {
            for (String chest : config.getConfigurationSection("LockedChests").getKeys(false)) {
                LockedChest c = new LockedChest(null, 0, 0, "Empty");
                c.load(config.getConfigurationSection("LockedChests." + chest));
                if (c.getLocation().getWorld() == null) continue;
                this.addOrEdit(c);
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        for (LockedChest chest : this.chests.values()) {
            chest.save(config.createSection("LockedChests." + chest.getLocation().getBlockX() + "-" + chest.getLocation().getBlockY() + "-" + chest.getLocation().getBlockZ()));
        }
    }
}

