/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.managers;

import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.rules.RuleValue;
import fr.devsylone.fkpi.util.Saveable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class RulesManager
implements Saveable {
    private final Map<Rule<?>, Object> rules = new LinkedHashMap();

    public RulesManager() {
        Rule.values().forEach(rule -> this.rules.put((Rule<?>)rule, rule.getDefaultValue()));
    }

    public <T> T getRule(Rule<T> rule) {
        return (T)Objects.requireNonNull(this.rules.get(rule), "The rule doesn't seem to be loaded. Has the manager been initialized?");
    }

    public <T> void setRule(Rule<T> rule, T value) {
        Bukkit.getPluginManager().callEvent(new RuleChangeEvent<T>(rule, value));
        this.rules.put(rule, value);
    }

    public Map<Rule<?>, Object> getRulesList() {
        return this.rules;
    }

    @Override
    public void load(ConfigurationSection config) {
        for (Map.Entry<Rule<?>, Object> entry : this.rules.entrySet()) {
            String configPath = "Rules." + entry.getKey().getName();
            if (entry.getKey().getDefaultValue() instanceof RuleValue) {
                RuleValue loaded = (RuleValue)entry.getKey().getDefaultValue();
                if (config != null && config.contains(configPath)) {
                    loaded.load(config.getConfigurationSection(configPath));
                } else {
                    loaded.fillWithDefaultValue();
                }
                this.rules.put(entry.getKey(), loaded);
                continue;
            }
            Object defaultValue = entry.getKey().getDefaultValue();
            if (defaultValue.getClass().equals(Character.class) && config != null) {
                String s;
                this.rules.put(entry.getKey(), Character.valueOf((s = config.getString(configPath + ".value", String.valueOf(defaultValue))).isEmpty() ? (char)' ' : s.charAt(0)));
                continue;
            }
            this.rules.put(entry.getKey(), config != null ? config.get(configPath + ".value", defaultValue) : defaultValue);
        }
    }

    @Override
    public void loadNullable(ConfigurationSection config) {
        this.load(config);
    }

    @Override
    public void save(ConfigurationSection config) {
        this.rules.forEach((rule, value) -> {
            if (value instanceof RuleValue) {
                ((RuleValue)value).save(config.createSection("Rules." + rule.getName()));
            } else {
                config.set("Rules." + rule.getName() + ".value", value);
            }
        });
    }
}

