/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.managers;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.display.NametagService;
import fr.devsylone.fallenkingdom.exception.FkLightException;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.version.Environment;
import fr.devsylone.fkpi.api.ITeam;
import fr.devsylone.fkpi.api.event.PlayerTeamChangeEvent;
import fr.devsylone.fkpi.api.event.TeamUpdateEvent;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamManager
implements Saveable {
    private final List<Team> teams = Collections.synchronizedList(new ArrayList());
    private final Map<UUID, Team> teamByPlayerUUID = new ConcurrentHashMap<UUID, Team>();
    private final NametagService nametagService = new NametagService(this);
    private static final String NAMETAG_INTEGRATION = "nametag-integration";

    @NotNull
    public Team createTeam(String name) {
        if (this.getTeam(name) != null) {
            throw new FkLightException(Messages.CMD_ERROR_TEAM_ALREADY_EXIST);
        }
        if (name.isEmpty() || name.contains(" ")) {
            throw new FkLightException(Messages.CMD_ERROR_TEAM_INVALID_NAME);
        }
        if (name.length() > 16) {
            throw new FkLightException(Messages.CMD_ERROR_TEAM_NAME_TOO_LONG);
        }
        Team team = new Team(name);
        Bukkit.getPluginManager().callEvent((Event)new TeamUpdateEvent((ITeam)team, TeamUpdateEvent.TeamUpdate.CREATION));
        this.teams.add(team);
        return team;
    }

    @NotNull
    public Scoreboard getScoreboard() {
        return this.nametagService.scoreboard();
    }

    @NotNull
    public NametagService nametag() {
        return this.nametagService;
    }

    public void removeTeam(String name) {
        Team team = this.getTeam(name);
        if (team == null) {
            throw new FkLightException(Messages.CMD_ERROR_UNKNOWN_TEAM.getMessage().replace("%team%", name));
        }
        Bukkit.getPluginManager().callEvent((Event)new TeamUpdateEvent((ITeam)team, TeamUpdateEvent.TeamUpdate.DELETION));
        for (String player : team.getPlayers()) {
            UUID uuid = Environment.getPlayerUniqueId(player);
            if (uuid == null) continue;
            this.teamByPlayerUUID.remove(uuid);
        }
        this.teams.remove(team);
        Fk.getInstance().getWorldManager().invalidateBaseWorldsCache(this);
    }

    @Nullable
    public Team getTeam(String name) {
        for (Team t : this.teams) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public Team getTeamOrThrow(String name) {
        Team team = this.getTeam(name);
        if (team == null) {
            throw new FkLightException(Messages.CMD_ERROR_UNKNOWN_TEAM.getMessage().replace("%team%", name));
        }
        return team;
    }

    @NotNull
    public @NotNull Optional<@NotNull Base> getBase(@NotNull Location location, int lag) {
        Objects.requireNonNull(location, "location");
        World world = location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        for (Team team : this.teams) {
            Base base = team.getBase();
            if (base == null || !base.contains(world, x, y, z, lag)) continue;
            return Optional.of(base);
        }
        return Optional.empty();
    }

    @NotNull
    public @NotNull Optional<@NotNull Base> getBase(@NotNull Location location) {
        return this.getBase(location, 0);
    }

    @NotNull
    public @NotNull Optional<@NotNull Base> getBase(@NotNull Block block, int lag) {
        Objects.requireNonNull(block, "block");
        for (Team team : this.teams) {
            Base base = team.getBase();
            if (base == null || !base.contains(block, lag)) continue;
            return Optional.of(base);
        }
        return Optional.empty();
    }

    @NotNull
    public @NotNull Optional<@NotNull Base> getBase(@NotNull Block block) {
        return this.getBase(block, 0);
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public List<String> getTeamNames() {
        return this.teams.stream().map(Team::getName).collect(Collectors.toList());
    }

    @Nullable
    public Team getPlayerTeam(String player) {
        if (player == null) {
            return null;
        }
        for (Team t : this.teams) {
            if (!t.getPlayers().contains(player)) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public Team getPlayerTeam(Player player) {
        if (player == null) {
            return null;
        }
        return this.teamByPlayerUUID.computeIfAbsent(player.getUniqueId(), s -> this.getPlayerTeam(player.getName()));
    }

    public ITeam addPlayer(String player, String teamName) {
        if (this.getPlayerTeam(player) != null) {
            throw new FkLightException(Messages.CMD_ERROR_PLAYER_ALREADY_HAS_TEAM);
        }
        if (this.getTeam(teamName) == null) {
            throw new FkLightException(Messages.CMD_ERROR_UNKNOWN_TEAM.getMessage().replace("%team%", teamName));
        }
        if (player.isEmpty() || player.contains(" ")) {
            throw new FkLightException(Messages.CMD_ERROR_INVALID_PLAYER.getMessage());
        }
        PlayerTeamChangeEvent event = new PlayerTeamChangeEvent(player, this.getPlayerTeam(player), this.getTeam(teamName));
        Bukkit.getPluginManager().callEvent((Event)event);
        event.getTeam().addPlayer(player);
        return event.getTeam();
    }

    public void removePlayerOfHisTeam(String player) {
        Team team = this.getPlayerTeam(player);
        if (team == null) {
            throw new FkLightException(Messages.CMD_ERROR_PLAYER_NOT_IN_TEAM);
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerTeamChangeEvent(player, team, null));
        team.removePlayer(player);
        UUID uuid = Environment.getPlayerUniqueId(player);
        if (uuid != null) {
            this.teamByPlayerUUID.remove(uuid);
        }
    }

    public void random(List<String> players) {
        if (this.getTeams().isEmpty()) {
            throw new FkLightException(Messages.CMD_ERROR_NO_TEAM);
        }
        Random rdm = new Random();
        int originalSize = players.size();
        for (int i = 0; i < originalSize; ++i) {
            int rdmi = rdm.nextInt(players.size());
            String p = players.get(rdmi);
            if (this.getPlayerTeam(p) != null) {
                this.removePlayerOfHisTeam(p);
            }
            this.teams.get(0).addPlayer(p);
            players.remove(rdmi);
        }
        int playerPerTeams = this.getTotalPlayers() / this.teams.size();
        for (Team t : this.teams) {
            t.balance(this.teams, playerPerTeams);
        }
    }

    public int getTotalPlayers() {
        int ret = 0;
        for (Team t : this.teams) {
            ret += t.getPlayers().size();
        }
        return ret;
    }

    @Override
    public void load(ConfigurationSection config) {
        this.teardown();
        this.teams.clear();
        this.nametagService.loadNullable(config.getConfigurationSection(NAMETAG_INTEGRATION));
        for (Map.Entry entry : config.getValues(false).entrySet()) {
            Team team;
            if (NAMETAG_INTEGRATION.equals(entry.getKey())) continue;
            try {
                team = this.createTeam((String)entry.getKey());
            }
            catch (FkLightException e) {
                e.printStackTrace();
                continue;
            }
            if (!(entry.getValue() instanceof ConfigurationSection)) continue;
            team.load((ConfigurationSection)entry.getValue());
        }
        Fk.getInstance().getWorldManager().invalidateBaseWorldsCache(this);
    }

    @Override
    public void save(ConfigurationSection config) {
        for (Team t : this.teams) {
            t.save(config.createSection(t.getName()));
        }
        this.nametagService.save(config.createSection(NAMETAG_INTEGRATION));
    }

    public void teardown() {
        this.nametagService.teardown(this.teams);
    }
}

