/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XBlock;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.rules.RuleValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class AllowedBlocks
implements RuleValue {
    private final Map<Material, Set<Byte>> allowed = Material.class.isEnum() ? new EnumMap(Material.class) : new HashMap();
    private final List<String> reducedList = new ArrayList<String>();
    private static final Set<Material> SIGNS = new HashSet<Material>();

    public boolean isAllowed(Material material, byte data) {
        Set<Byte> datas = this.allowed.get(material);
        if (datas == null) {
            return false;
        }
        return datas.isEmpty() || datas.contains(data);
    }

    public boolean isAllowed(Block block) {
        return this.isAllowed(block.getType(), XBlock.isFlat() ? (byte)0 : block.getData());
    }

    public List<String> reducedList() {
        if (!this.reducedList.isEmpty() || this.allowed.isEmpty()) {
            return this.reducedList;
        }
        boolean allSigns = this.allowed.keySet().containsAll(SIGNS);
        for (Map.Entry<Material, Set<Byte>> entry : this.allowed.entrySet()) {
            String name = entry.getKey().name();
            if (entry.getValue().isEmpty()) {
                if (allSigns && SIGNS.contains(entry.getKey())) continue;
                this.reducedList.add(name);
                continue;
            }
            for (byte data : entry.getValue()) {
                this.reducedList.add(name + ':' + data);
            }
        }
        if (allSigns) {
            this.reducedList.add("SIGN (" + Messages.CMD_MAP_RULES_ALLOW_BLOCK_SIGN.getMessage() + ")");
        }
        return this.reducedList;
    }

    @Override
    public void fillWithDefaultValue() {
        this.add(Material.TORCH);
        if (XBlock.isFlat()) {
            this.add(Material.WALL_TORCH);
            this.add(Material.REDSTONE_TORCH);
            this.add(Material.REDSTONE_WALL_TORCH);
        } else {
            this.add(Material.valueOf((String)"REDSTONE_TORCH_ON"));
        }
        this.add(Material.FIRE);
        for (Material sign : SIGNS) {
            this.add(sign);
        }
    }

    @Override
    public JsonElement toJSON() {
        JsonArray jsonArray = new JsonArray();
        for (Material material : this.allowed.keySet()) {
            jsonArray.add(material.toString());
        }
        return jsonArray;
    }

    @Override
    public String format() {
        StringBuilder formatted = new StringBuilder();
        for (String b : this.reducedList()) {
            formatted.append("\n\u00a7a\u2714 ").append(b);
        }
        return formatted.toString();
    }

    @Override
    public void load(ConfigurationSection config) {
        for (String name : config.getStringList("value")) {
            Material material;
            int sep = name.indexOf(58);
            if (sep < 0) {
                material = Material.matchMaterial((String)name);
                if (material == null) {
                    Fk.getInstance().getLogger().warning(Messages.CONSOLE_UNKNOWN_MATERIAL.getMessage() + " " + name);
                    continue;
                }
                this.allowed.put(material, Collections.emptySet());
                continue;
            }
            material = Material.matchMaterial((String)name.substring(0, sep));
            if (material == null) {
                Fk.getInstance().getLogger().warning(Messages.CONSOLE_UNKNOWN_MATERIAL.getMessage() + " " + name);
                continue;
            }
            this.allowed.computeIfAbsent(material, s -> new HashSet()).add(Byte.parseByte(name.substring(sep + 1)));
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        ArrayList<String> blocksString = new ArrayList<String>(this.allowed.size());
        for (Map.Entry<Material, Set<Byte>> entry : this.allowed.entrySet()) {
            String name = entry.getKey().name();
            if (entry.getValue().isEmpty()) {
                blocksString.add(name);
                continue;
            }
            for (byte data : entry.getValue()) {
                blocksString.add(name + ':' + data);
            }
        }
        config.set("value", blocksString);
    }

    public String toString() {
        return "Blocks[" + this.allowed.entrySet().stream().map(entry -> entry.getKey() + "(" + entry.getValue() + ")").collect(Collectors.joining(", ")) + "]";
    }

    public void add(Material material) {
        Bukkit.getPluginManager().callEvent(new RuleChangeEvent<AllowedBlocks>(Rule.ALLOWED_BLOCKS, this));
        if (!Collections.emptySet().equals(this.allowed.put(material, Collections.emptySet()))) {
            this.reducedList.clear();
        }
    }

    public void add(Material material, byte data) {
        if (data < 0) {
            this.add(material);
            return;
        }
        Bukkit.getPluginManager().callEvent(new RuleChangeEvent<AllowedBlocks>(Rule.ALLOWED_BLOCKS, this));
        if (this.allowed.computeIfAbsent(material, s -> new HashSet()).add(data)) {
            this.reducedList.clear();
        }
    }

    public void remove(Material material) {
        Bukkit.getPluginManager().callEvent(new RuleChangeEvent<AllowedBlocks>(Rule.ALLOWED_BLOCKS, this));
        if (this.allowed.remove(material) != null) {
            this.reducedList.clear();
        }
    }

    public void remove(Material material, byte data) {
        if (data < 0) {
            this.remove(material);
            return;
        }
        Set<Byte> datas = this.allowed.get(material);
        if (datas != null) {
            Bukkit.getPluginManager().callEvent(new RuleChangeEvent<AllowedBlocks>(Rule.ALLOWED_BLOCKS, this));
            boolean removed = datas.remove(data);
            if (removed && datas.isEmpty()) {
                this.allowed.remove(material);
            }
            if (removed) {
                this.reducedList.clear();
            }
        }
    }

    static {
        try {
            Class.forName("org.bukkit.Tag").getField("SIGNS");
            SIGNS.addAll(new HashSet(Tag.SIGNS.getValues()));
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            if (XBlock.isFlat()) {
                SIGNS.add(XMaterial.OAK_SIGN.parseMaterial());
            } else {
                SIGNS.add(Material.valueOf((String)"SIGN_POST"));
            }
            SIGNS.add(XMaterial.OAK_WALL_SIGN.parseMaterial());
        }
    }
}

