/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.rules;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.rules.RuleValue;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class ChargedCreepers
implements RuleValue {
    private int spawn = 10;
    private int drop = 50;
    private int tntAmount = 1;

    public int getSpawn() {
        return this.spawn;
    }

    public int getDrop() {
        return this.drop;
    }

    public int getTntAmount() {
        return this.tntAmount;
    }

    public void setSpawn(int spawn) {
        this.spawn = spawn;
    }

    public void setDrop(int drop) {
        this.drop = drop;
    }

    public void setTntAmount(int amount) {
        this.tntAmount = amount;
    }

    public void setValue(int spawn, int drop, int amount) {
        Bukkit.getPluginManager().callEvent(new RuleChangeEvent<ChargedCreepers>(Rule.CHARGED_CREEPERS, this));
        this.setSpawn(spawn);
        this.setDrop(drop);
        this.setTntAmount(amount);
    }

    @Override
    public String format() {
        return "\u00a7e" + this.spawn + "% spawn - " + this.drop + "% drop - " + this.tntAmount + " tnt(s)";
    }

    @Override
    public JsonElement toJSON() {
        return new Gson().toJsonTree((Object)this);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("value", (Object)(this.spawn * 1000000 + this.drop * 1000 + this.tntAmount));
    }

    @Override
    public void load(ConfigurationSection config) {
        int value = config.getInt("value", 10050001);
        this.spawn = value / 1000000;
        this.drop = value / 1000 - value / 1000000 * 1000;
        this.tntAmount = value - value / 1000 * 1000;
    }

    public String toString() {
        return "[" + this.spawn + ", " + this.drop + ", " + this.tntAmount + "]";
    }
}

