/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.rules;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.rules.RuleValue;
import fr.devsylone.fkpi.util.XPotionData;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class DisabledPotions
implements RuleValue {
    private final Set<XPotionData> effects = new HashSet<XPotionData>();

    public Set<XPotionData> getValue() {
        return this.effects;
    }

    public boolean isDisabled(XPotionData potionData) {
        return potionData != null && this.effects.contains(potionData);
    }

    public boolean disablePotion(XPotionData potionData) {
        if (this.effects.add(potionData)) {
            Bukkit.getPluginManager().callEvent(new RuleChangeEvent<DisabledPotions>(Rule.DISABLED_POTIONS, this));
            return true;
        }
        return false;
    }

    public boolean enablePotion(XPotionData potionData) {
        if (this.effects.remove(potionData)) {
            Bukkit.getPluginManager().callEvent(new RuleChangeEvent<DisabledPotions>(Rule.DISABLED_POTIONS, this));
            return true;
        }
        return false;
    }

    public boolean togglePotion(@NotNull XPotionData data) {
        if (this.disablePotion(data)) {
            return false;
        }
        return this.enablePotion(data);
    }

    @Override
    public String format() {
        StringBuilder formatted = new StringBuilder();
        for (XPotionData data : this.effects) {
            formatted.append("\n\u00a7c\u2718 ").append(data.getType().name()).append(data.isExtended() ? " + redstone" : (data.isUpgraded() ? " + glowstone" : ""));
        }
        return formatted.toString();
    }

    @Override
    public JsonElement toJSON() {
        Gson gson = new Gson();
        JsonArray jsonArray = new JsonArray();
        for (XPotionData potion : this.getValue()) {
            jsonArray.add(gson.toJsonTree((Object)potion));
        }
        return jsonArray;
    }

    @Override
    public void save(ConfigurationSection config) {
        int i = 0;
        for (XPotionData potion : this.effects) {
            config.set(i + ".Type", (Object)potion.getType().name());
            config.set(i + ".Extended", (Object)potion.isExtended());
            config.set(i + ".Upgraded", (Object)potion.isUpgraded());
            ++i;
        }
    }

    @Override
    public void load(ConfigurationSection config) {
        for (String key : config.getKeys(false)) {
            this.effects.add(new XPotionData(PotionType.valueOf((String)config.getString(key + ".Type")), config.getBoolean(key + ".Extended"), config.getBoolean(key + ".Upgraded")));
        }
    }

    public String toString() {
        return "[" + this.effects.stream().map(XPotionData::toString).collect(Collectors.joining(", ")) + "]";
    }
}

