/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.rules;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fkpi.api.event.RuleChangeEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.rules.RuleValue;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class PlaceBlockInCave
implements RuleValue {
    private boolean active = false;
    private int minimumBlocks = 3;

    public boolean isActive() {
        return this.active;
    }

    public int getMinimumBlocks() {
        return this.minimumBlocks;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            Bukkit.getPluginManager().callEvent(new RuleChangeEvent<PlaceBlockInCave>(Rule.PLACE_BLOCK_IN_CAVE, this));
        }
        this.active = active;
    }

    public void setMinimumBlocks(int value) {
        if (value != this.minimumBlocks) {
            Bukkit.getPluginManager().callEvent(new RuleChangeEvent<PlaceBlockInCave>(Rule.PLACE_BLOCK_IN_CAVE, this));
        }
        this.minimumBlocks = value;
    }

    @Override
    public String format() {
        return this.active ? "\u00a7e" + this.minimumBlocks + " " + Messages.UNIT_BLOCKS.getMessage() : "\u00a74\u2718";
    }

    @Override
    public JsonElement toJSON() {
        return new Gson().toJsonTree((Object)this);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("value", (Object)this.active);
        config.set("MinimumBlocs", (Object)this.minimumBlocks);
    }

    @Override
    public void load(ConfigurationSection config) {
        this.active = config.getBoolean("value", this.active);
        this.minimumBlocks = config.getInt("MinimumBlocs", this.minimumBlocks);
    }

    public String toString() {
        return this.active + "(" + this.minimumBlocks + ")";
    }
}

