/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.rules;

import fr.devsylone.fkpi.rules.AllowedBlocks;
import fr.devsylone.fkpi.rules.AutoPause;
import fr.devsylone.fkpi.rules.ChargedCreepers;
import fr.devsylone.fkpi.rules.DisabledPotions;
import fr.devsylone.fkpi.rules.PlaceBlockInCave;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Rule<T> {
    protected final String name;
    protected final T defaultValue;
    private static final Map<String, Rule<?>> RULES = new HashMap();
    public static final Rule<Integer> PVP_CAP = new Rule<Integer>("PvpCap", 3);
    public static final Rule<Integer> TNT_CAP = new Rule<Integer>("TntCap", 6);
    public static final Rule<Integer> NETHER_CAP = new Rule<Integer>("NetherCap", 1);
    public static final Rule<Integer> END_CAP = new Rule<Integer>("EndCap", 1);
    public static final Rule<Integer> DEATH_LIMIT = new Rule<Integer>("DeathLimit", 0);
    public static final Rule<Integer> CHEST_LIMIT = new Rule<Integer>("ChestLimit", 20);
    public static final Rule<Integer> VERTICAL_LIMIT = new Rule<Integer>("VerticalLimit", 40);
    public static final Rule<Integer> DAY_DURATION = new Rule<Integer>("DayDuration", 24000);
    public static final Rule<Integer> CAPTURE_RATE = new Rule<Integer>("CaptureRate", 100);
    public static final Rule<Boolean> FRIENDLY_FIRE = new Rule<Boolean>("FriendlyFire", true);
    public static final Rule<Boolean> ETERNAL_DAY = new Rule<Boolean>("EternalDay", false);
    public static final Rule<Boolean> DEEP_PAUSE = new Rule<Boolean>("DeepPause", true);
    public static final Rule<Boolean> TNT_JUMP = new Rule<Boolean>("TntJump", true);
    public static final Rule<Boolean> RESPAWN_AT_HOME = new Rule<Boolean>("RespawnAtHome", false);
    public static final Rule<Boolean> HEALTH_BELOW_NAME = new Rule<Boolean>("HealthBelowName", true);
    public static final Rule<Boolean> BLAST_PROOF_BASE = new Rule<Boolean>("BlastProofBase", false);
    public static final Rule<Boolean> BUCKET_ASSAULT = new Rule<Boolean>("BucketAssault", false);
    public static final Rule<Boolean> ENDERPEARL_ASSAULT = new Rule<Boolean>("EnderpearlAssault", true);
    public static final Rule<Boolean> NETHER_ASSAULT = new Rule<Boolean>("NetherAssault", false);
    public static final Rule<Boolean> PRIVATE_CHESTS = new Rule<Boolean>("PrivateChests", false);
    public static final Rule<Character> GLOBAL_CHAT_PREFIX = new Rule<Character>("GlobalChatPrefix", Character.valueOf('!'));
    public static final Rule<AutoPause> AUTO_PAUSE = new Rule<AutoPause>("AutoPause", new AutoPause());
    public static final Rule<AllowedBlocks> ALLOWED_BLOCKS = new Rule<AllowedBlocks>("AllowedBlocks", new AllowedBlocks());
    public static final Rule<ChargedCreepers> CHARGED_CREEPERS = new Rule<ChargedCreepers>("ChargedCreepers", new ChargedCreepers());
    public static final Rule<DisabledPotions> DISABLED_POTIONS = new Rule<DisabledPotions>("DisabledPotions", new DisabledPotions());
    public static final Rule<PlaceBlockInCave> PLACE_BLOCK_IN_CAVE = new Rule<PlaceBlockInCave>("PlaceBlockInCave", new PlaceBlockInCave());

    Rule(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        RULES.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public static <T> Rule<T> getByName(String name) {
        return RULES.get(name);
    }

    public static Set<Rule<?>> values() {
        return new HashSet(RULES.values());
    }
}

