/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.teams;

import fr.devsylone.fallenkingdom.utils.XBlock;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fallenkingdom.version.Environment;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.ChestsRoom;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.OutlineSquareIterator;
import fr.devsylone.fkpi.util.Saveable;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Base
implements Saveable {
    private Team team;
    private Location center;
    private Location tp;
    private int radius;
    private Material material;
    private byte data;
    private Nexus nexus;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;

    public Base(Team team, @Nullable Location center, int radius, Material material, byte data) {
        this.center = center != null ? Base.adjustLoc(center) : null;
        this.radius = radius;
        this.team = team;
        this.material = material;
        this.data = data;
        this.nexus = new ChestsRoom(this);
        if (center != null) {
            this.tp = this.getCenter().add(0.0, 1.0, 1.0);
        }
        this.updateMinMaxLoc();
    }

    private void updateMinMaxLoc() {
        if (this.center == null) {
            return;
        }
        this.minX = this.center.getBlockX() - this.radius;
        this.minZ = this.center.getBlockZ() - this.radius;
        this.maxX = this.center.getBlockX() + this.radius;
        this.maxZ = this.center.getBlockZ() + this.radius;
    }

    public boolean contains(World world, int x, int y, int z, int lag) {
        int verticalLimit = FkPI.getInstance().getRulesManager().getRule(Rule.VERTICAL_LIMIT);
        if (verticalLimit > 0 && Math.abs(y - this.center.getBlockY()) > verticalLimit) {
            return false;
        }
        return x >= this.minX - lag && x <= this.maxX + lag && z >= this.minZ - lag && z <= this.maxZ + lag && Objects.equals(world, this.center.getWorld());
    }

    public boolean contains(World world, int x, int y, int z) {
        return this.contains(world, x, y, z, 0);
    }

    public boolean contains(Location loc, int lag) {
        return this.contains(loc.getWorld(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), lag);
    }

    public boolean contains(Location loc) {
        return this.contains(loc, 0);
    }

    public boolean contains(Block block, int lag) {
        return this.contains(block.getWorld(), block.getX(), block.getY(), block.getZ(), lag);
    }

    public boolean contains(Block block) {
        return this.contains(block, 0);
    }

    public Location getTpPoint() {
        return this.tp.clone();
    }

    public Location getCenter() {
        return this.center.clone();
    }

    @Deprecated
    @Nullable
    public ChestsRoom getChestsRoom() {
        if (this.nexus instanceof ChestsRoom) {
            return (ChestsRoom)this.nexus;
        }
        return null;
    }

    public void setChestsRoom(@NotNull Nexus room) {
        this.nexus.remove();
        this.nexus = room;
    }

    @NotNull
    public Nexus getNexus() {
        return this.nexus;
    }

    public void resetChestRoom() {
        this.nexus.reset();
    }

    public void markNexusAsCaptured() {
        ChestsRoom room = new ChestsRoom(this);
        room.markAsCaptured();
        this.setChestsRoom(room);
    }

    public Team getTeam() {
        return this.team;
    }

    public int getRadius() {
        return this.radius;
    }

    public void constructBorder() {
        if (this.material == Material.AIR) {
            return;
        }
        OutlineSquareIterator iterator = this.outlineIterator();
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            Base.adjustLoc(location);
            location.getBlock().setType(this.material);
            XBlock.setData(location.getBlock(), this.data);
        }
    }

    public OutlineSquareIterator outlineIterator() {
        return new OutlineSquareIterator(this.center.getBlockX() - this.radius, this.center.getBlockY(), this.center.getBlockZ() - this.radius, this.radius * 2, this.center.getWorld());
    }

    public boolean isLoaded() {
        World world = this.center.getWorld();
        if (world == null) {
            return false;
        }
        for (int x = this.center.getBlockX() - this.radius; x <= this.center.getBlockX() + this.radius; x += 16) {
            for (int z = this.center.getBlockZ() - this.radius; z <= this.center.getBlockZ() + this.radius; z += 16) {
                if (world.isChunkLoaded(x >> 4, z >> 4)) continue;
                return false;
            }
        }
        return true;
    }

    public void construct() {
        this.constructFlag();
        this.constructBorder();
    }

    public void constructFlag() {
        int i;
        Base.adjustLoc(this.center);
        Location index = this.center.clone();
        for (i = 0; i < 3; ++i) {
            index.getBlock().setType(XMaterial.OAK_FENCE.parseMaterial());
            index.add(0.0, 1.0, 0.0);
        }
        index.add(1.0, -2.0, 0.0);
        for (i = 0; i < 2; ++i) {
            for (int k = 0; k < 2; ++k) {
                index.getBlock().setType(XMaterial.WHITE_WOOL.parseMaterial());
                XBlock.setColor(index.getBlock(), this.team.getColor().getDyeColor());
                index.add(0.0, 1.0, 0.0);
            }
            index.add(-2.0, -2.0, 0.0);
        }
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static Location adjustLoc(@NotNull Location loc) {
        loc.setX((double)loc.getBlockX());
        loc.setY((double)loc.getBlockY());
        loc.setZ((double)loc.getBlockZ());
        World world = loc.getWorld();
        if (world == null) {
            return loc;
        }
        while (XBlock.isReplaceable(loc.getBlock()) && loc.getBlockY() > Environment.getMinHeight(world) + 1) {
            loc.add(0.0, -1.0, 0.0);
        }
        while (!XBlock.isReplaceable(loc.getBlock())) {
            loc.add(0.0, 1.0, 0.0);
        }
        loc.add(0.5, 0.5, 0.5);
        return loc;
    }

    @Override
    public void load(ConfigurationSection config) {
        this.center = new Location(Bukkit.getWorld((String)config.getString("Center.World")), (double)config.getInt("Center.X") + 0.5, (double)config.getInt("Center.Y") + 0.5, (double)config.getInt("Center.Z") + 0.5);
        this.tp = this.getCenter().clone().add(0.0, 1.0, 1.0);
        this.material = Material.matchMaterial((String)config.getString("Material"));
        this.radius = config.getInt("Radius");
        ConfigurationSection nexusConfig = config.getConfigurationSection("Nexus");
        if (nexusConfig != null) {
            this.nexus = Nexus.fromConfig(this, nexusConfig);
        } else {
            nexusConfig = config.getConfigurationSection("ChestsRoom");
            if (nexusConfig != null) {
                ChestsRoom chestsRoom = new ChestsRoom(this);
                chestsRoom.load(nexusConfig);
                this.nexus = chestsRoom;
            }
        }
        this.updateMinMaxLoc();
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("Center.World", (Object)this.center.getWorld().getName());
        config.set("Center.X", (Object)this.center.getBlockX());
        config.set("Center.Y", (Object)this.center.getBlockY());
        config.set("Center.Z", (Object)this.center.getBlockZ());
        config.set("Material", (Object)this.material.name());
        config.set("Radius", (Object)this.radius);
        this.nexus.save(config.createSection("Nexus"));
    }
}

