/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.teams;

import fr.devsylone.fallenkingdom.Fk;
import fr.devsylone.fallenkingdom.game.ChestRoomRunnable;
import fr.devsylone.fallenkingdom.utils.ChatUtils;
import fr.devsylone.fallenkingdom.utils.Messages;
import fr.devsylone.fallenkingdom.utils.XBlock;
import fr.devsylone.fallenkingdom.utils.XMaterial;
import fr.devsylone.fallenkingdom.version.packet.block.MultiBlockChange;
import fr.devsylone.fallenkingdom.version.packet.entity.Hologram;
import fr.devsylone.fallenkingdom.version.packet.entity.ItemSlot;
import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.event.TeamCaptureEvent;
import fr.devsylone.fkpi.rules.Rule;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.Nexus;
import fr.devsylone.fkpi.teams.Team;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class ChestsRoom
implements Nexus,
Saveable {
    private Location min;
    private Location max;
    private final List<Location> chests = new ArrayList<Location>();
    private final List<UUID> enemyInside = new ArrayList<UUID>();
    private final List<UUID> alliesInside = new ArrayList<UUID>();
    private ChestRoomState state = ChestRoomState.NORMAL;
    private final Base base;
    private BukkitTask captureTask;
    private Team captureTeam;
    static final String CHESTS_ROOM = "chests-room";

    public ChestsRoom(@NotNull Base base) {
        this.base = base;
    }

    public static boolean isIn(Location test, Location min, Location max, int offset) {
        return min != null && test.getX() >= Math.min(min.getX(), max.getX()) + (double)offset && test.getY() >= Math.min(min.getY(), max.getY()) + (double)offset && test.getZ() >= Math.min(min.getZ(), max.getZ()) + (double)offset && test.getX() <= Math.max(min.getX(), max.getX()) - (double)offset && test.getY() <= Math.max(min.getY(), max.getY()) - (double)offset && test.getZ() <= Math.max(min.getZ(), max.getZ() - (double)offset);
    }

    @Override
    public boolean contains(@NotNull Location test) {
        if (this.min == null || this.max == null) {
            return this.base.contains(test);
        }
        return ChestsRoom.isIn(test, this.min, this.max, 0);
    }

    public void markAsCaptured() {
        this.state = ChestRoomState.CAPTURED;
    }

    public void removeChest(Location loc) {
        if (!this.chests.contains(loc)) {
            return;
        }
        this.chests.remove(loc);
        if (this.chests.isEmpty()) {
            this.min = null;
            this.max = null;
        } else {
            this.min = null;
            this.max = null;
            for (Location chest : this.chests) {
                this.newChest(chest);
            }
        }
    }

    public void newChest(Location loc) {
        if (!this.chests.contains(loc)) {
            this.chests.add(loc);
        }
        if (this.min == null) {
            this.max = loc.clone().add((double)this.getOffset(), (double)this.getOffset(), (double)this.getOffset());
            this.min = loc.clone().add((double)(-this.getOffset()), (double)(-this.getOffset()), (double)(-this.getOffset()));
        } else if (!ChestsRoom.isIn(loc, this.min, this.max, this.getOffset())) {
            if (loc.getX() > this.max.getX() - (double)this.getOffset()) {
                this.max.setX(loc.getX() + (double)this.getOffset());
            } else if (loc.getX() < this.min.getX() + (double)this.getOffset()) {
                this.min.setX(loc.getX() - (double)this.getOffset());
            }
            if (loc.getY() > this.max.getY() - (double)this.getOffset()) {
                this.max.setY(loc.getY() + (double)this.getOffset());
            } else if (loc.getY() < this.min.getY() + (double)this.getOffset()) {
                this.min.setY(loc.getY() - (double)this.getOffset());
            }
            if (loc.getZ() > this.max.getZ() - (double)this.getOffset()) {
                this.max.setZ(loc.getZ() + (double)this.getOffset());
            } else if (loc.getZ() < this.min.getZ() + (double)this.getOffset()) {
                this.min.setZ(loc.getZ() - (double)this.getOffset());
            }
        }
    }

    public void show(final Player p, final int seetime) {
        if (this.chests.isEmpty() || this.min == null) {
            throw new IllegalStateException("Cannot show a chest room without any chest.");
        }
        final Location initLoc = p.getLocation().clone();
        double xDif = this.max.getX() - this.min.getX();
        double yDif = this.max.getY() - this.min.getY();
        double zDif = this.max.getZ() - this.min.getZ();
        MultiBlockChange change = MultiBlockChange.create();
        int ix = 0;
        while ((double)ix <= Math.abs(xDif)) {
            int iy = 0;
            while ((double)iy <= Math.abs(yDif)) {
                int iz = 0;
                while ((double)iz <= Math.abs(zDif)) {
                    Location loc = this.min.clone().add(xDif < 0.0 ? (double)(-ix) : (double)ix, yDif < 0.0 ? (double)(-iy) : (double)iy, zDif < 0.0 ? (double)(-iz) : (double)iz);
                    int inter = (double)ix == Math.abs(xDif) ? 1 : 0;
                    inter += (double)iy == Math.abs(yDif) ? 1 : 0;
                    inter += (double)iz == Math.abs(zDif) ? 1 : 0;
                    inter += ix == 0 ? 1 : 0;
                    inter += iy == 0 ? 1 : 0;
                    inter += iz == 0 ? 1 : 0;
                    if (!loc.equals((Object)p.getLocation().add(0.0, -1.0, 0.0).getBlock().getLocation()) && XBlock.isBlockInCave(loc.getBlock().getType()) || loc.getBlock().getType() == Material.SAND || loc.getBlock().getType() == Material.COBBLESTONE || loc.getBlock().getType() == Material.DIRT || loc.getBlock().getType() == XMaterial.GRASS_BLOCK.parseMaterial() || loc.getBlock().getType() == Material.GRAVEL || loc.getBlock().getType().name().contains("ORE")) {
                        change.change(loc.getBlock(), Material.AIR);
                    }
                    int id = -1;
                    if (inter > 0) {
                        if (inter > 1) {
                            id = Hologram.INSTANCE.displayItem(ItemSlot.HEAD, p, loc.add(0.5, -1.0, 0.5), Material.CHEST);
                        } else if (this.min.distanceSquared(this.max) <= 400.0) {
                            id = Hologram.INSTANCE.displayItem(ItemSlot.MAINHAND, p, loc.add(1.0, 0.0, 0.0), Material.CHEST);
                        }
                    }
                    int finalid = id;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Fk.getInstance(), () -> {
                        if (finalid > 0) {
                            Hologram.INSTANCE.remove(p, finalid);
                        }
                    }, (long)Math.abs(seetime) * 20L);
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        change.send(p);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Fk.getInstance(), () -> change.cancel(p), (long)Math.abs(seetime) * 20L);
        new BukkitRunnable(this){
            int i = 0;
            final /* synthetic */ ChestsRoom this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (++this.i >= seetime) {
                    this.cancel();
                }
                if (p.getLocation().getBlockX() == initLoc.getBlockX() && p.getLocation().getBlockZ() == initLoc.getBlockZ()) {
                    return;
                }
                initLoc.setYaw(p.getLocation().getYaw());
                initLoc.setPitch(p.getLocation().getPitch());
                p.teleport(initLoc.clone().add(0.0, 0.2, 0.0));
            }
        }.runTaskTimer((Plugin)Fk.getInstance(), 20L, 20L);
    }

    @Override
    public void addEnemyInside(@NotNull Player player) {
        Team team = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
        if (team != null && !team.equals(this.base.getTeam())) {
            this.enemyInside.add(player.getUniqueId());
            if (Fk.getInstance().getGame().isAssaultsEnabled() && !Fk.getInstance().getGame().isPaused() && (float)this.enemyInside.size() / (float)team.getPlayers().size() * 100.0f >= (float)FkPI.getInstance().getRulesManager().getRule(Rule.CAPTURE_RATE).intValue()) {
                this.startCapture(team);
            }
        } else {
            this.alliesInside.add(player.getUniqueId());
        }
    }

    @Override
    public void removeEnemyInside(@NotNull Player player) {
        Team team = FkPI.getInstance().getTeamManager().getPlayerTeam(player);
        if (team != null && !team.equals(this.base.getTeam())) {
            this.enemyInside.remove(player.getUniqueId());
            if ((float)this.enemyInside.size() / (float)team.getPlayers().size() * 100.0f >= (float)FkPI.getInstance().getRulesManager().getRule(Rule.CAPTURE_RATE).intValue()) {
                return;
            }
            if (this.captureTeam != null && this.captureTeam.equals(team) && this.state != ChestRoomState.CAPTURED) {
                for (String mate : team.getPlayers()) {
                    Player p = Bukkit.getPlayer((String)mate);
                    if (p == null) continue;
                    ChatUtils.sendMessage((CommandSender)p, team.getChatColor() + Messages.PLAYER_CHEST_ROOM_CAPTURE_INTERRUPTED.getMessage().replace("%player%", player.getDisplayName()));
                }
                this.remove();
            }
        } else {
            this.alliesInside.remove(player.getUniqueId());
        }
    }

    @Override
    public boolean isInside(@NotNull Player player) {
        return this.enemyInside.contains(player.getUniqueId()) || this.alliesInside.contains(player.getUniqueId());
    }

    @Override
    public boolean isDefined() {
        return this.min != null && this.max != null;
    }

    public List<UUID> getEnemiesInside() {
        return this.enemyInside;
    }

    public void startCapture(Team team) {
        if (this.state != ChestRoomState.NORMAL) {
            return;
        }
        this.state = ChestRoomState.CAPTURING;
        this.captureTeam = team;
        Bukkit.getServer().getPluginManager().callEvent((Event)new TeamCaptureEvent(team, this.base.getTeam(), false));
        for (String player : team.getPlayers()) {
            Player p = Bukkit.getPlayer((String)player);
            if (p == null) continue;
            ChatUtils.sendMessage((CommandSender)p, team.getChatColor() + Messages.PLAYER_CHEST_ROOM_CAPTURE_STARTED.getMessage());
        }
        this.captureTask = new ChestRoomRunnable(this, team, this.base.getTeam()).runTaskTimer((Plugin)Fk.getInstance(), 5L, 5L);
    }

    public ChestRoomState getState() {
        return this.state;
    }

    @Override
    public void load(ConfigurationSection config) {
        String state = config.getString("state");
        if (state != null) {
            this.state = ChestRoomState.valueOf(state);
        }
        if (!config.isConfigurationSection("Chests")) {
            return;
        }
        for (String key : config.getConfigurationSection("Chests").getKeys(false)) {
            this.newChest(new Location(Bukkit.getWorld((String)config.getString("Chests." + key + ".World")), (double)config.getInt("Chests." + key + ".X"), (double)config.getInt("Chests." + key + ".Y"), (double)config.getInt("Chests." + key + ".Z")));
        }
    }

    @Override
    public void save(@NotNull ConfigurationSection config) {
        config.set("type", (Object)CHESTS_ROOM);
        config.set("state", (Object)this.state.name());
        if (this.chests.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.chests.size(); ++i) {
            Location chest = this.chests.get(i);
            config.set("Chests." + i + ".World", (Object)chest.getWorld().getName());
            config.set("Chests." + i + ".X", (Object)chest.getBlockX());
            config.set("Chests." + i + ".Y", (Object)chest.getBlockY());
            config.set("Chests." + i + ".Z", (Object)chest.getBlockZ());
        }
    }

    private int getOffset() {
        return FkPI.getInstance().getChestsRoomsManager().getOffset();
    }

    @Override
    @NotNull
    public Base getBase() {
        return this.base;
    }

    @Override
    public void reset() {
        this.enemyInside.clear();
        this.alliesInside.clear();
        if (this.captureTask != null) {
            this.captureTask.cancel();
        }
        this.captureTask = null;
        this.captureTeam = null;
        this.state = ChestRoomState.NORMAL;
    }

    @Override
    public void remove() {
        this.reset();
    }

    public boolean exists() {
        return !this.chests.isEmpty();
    }

    public String toString() {
        return "ChestsRoom{min=" + this.min + ", max=" + this.max + ", chests=" + this.chests.size() + ", enemyInside=" + this.enemyInside + ", state=" + (Object)((Object)this.state) + ", team=" + this.base.getTeam() + ", captureTeam=" + this.captureTeam + '}';
    }

    public static enum ChestRoomState {
        NORMAL,
        CAPTURING,
        CAPTURED;

    }
}

