/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.teams;

import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.teams.ChestsRoom;
import fr.devsylone.fkpi.teams.CrystalCore;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Nexus {
    @Contract(pure=true)
    public boolean contains(@NotNull Location var1);

    public void addEnemyInside(@NotNull Player var1);

    public void removeEnemyInside(@NotNull Player var1);

    @Contract(pure=true)
    public boolean isInside(@NotNull Player var1);

    @Contract(pure=true)
    default public boolean isDefined() {
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public Base getBase();

    public void reset();

    public void remove();

    public void save(@NotNull ConfigurationSection var1);

    @NotNull
    public static Nexus fromConfig(@NotNull Base base, @NotNull ConfigurationSection config) {
        String nexusType = config.getString("type");
        if ("core".equals(nexusType)) {
            String entity = config.getString("entity");
            UUID coreId = entity == null ? new UUID(0L, 0L) : UUID.fromString(entity);
            int damage = config.getInt("damage");
            return new CrystalCore(base, coreId, base.getTeam().getColor().getBukkitChatColor(), damage);
        }
        if ("chests-room".equals(nexusType)) {
            ChestsRoom chestsRoom = new ChestsRoom(base);
            chestsRoom.load(config);
            return chestsRoom;
        }
        throw new IllegalArgumentException("Unknown nexus type: " + nexusType);
    }
}

