/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.teams;

import fr.devsylone.fkpi.FkPI;
import fr.devsylone.fkpi.api.ITeam;
import fr.devsylone.fkpi.api.event.TeamUpdateEvent;
import fr.devsylone.fkpi.teams.Base;
import fr.devsylone.fkpi.util.Color;
import fr.devsylone.fkpi.util.Saveable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Team
implements ITeam,
Saveable {
    private String name;
    private Base base;
    private List<String> players;
    private Color color;

    public Team(String name) {
        this.name = name;
        this.players = new ArrayList<String>();
        this.setColor(Color.of(name));
    }

    @Override
    public void addPlayer(@NotNull String p) {
        this.players.add(p);
    }

    @Override
    public void removePlayer(@NotNull String p) {
        this.players.remove(p);
    }

    public void setBase(Base base) {
        Bukkit.getPluginManager().callEvent((Event)new TeamUpdateEvent((ITeam)this, TeamUpdateEvent.TeamUpdate.SET_BASE));
        this.base = base;
    }

    @Override
    @NotNull
    public List<String> getPlayers() {
        return Collections.unmodifiableList(this.players);
    }

    @Override
    public void setName(@NotNull String name) {
        Bukkit.getPluginManager().callEvent((Event)new TeamUpdateEvent((ITeam)this, TeamUpdateEvent.TeamUpdate.UPDATE));
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Base getBase() {
        return this.base;
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public ChatColor getChatColor() {
        return this.color.getChatColor();
    }

    @Override
    @NotNull
    public DyeColor getDyeColor() {
        return this.color.getDyeColor();
    }

    public void setColor(@Nullable Color color) {
        Bukkit.getPluginManager().callEvent((Event)new TeamUpdateEvent((ITeam)this, TeamUpdateEvent.TeamUpdate.UPDATE));
        this.color = color == null ? Color.BLANC : color;
    }

    @Deprecated
    @NotNull
    public org.bukkit.scoreboard.Team getScoreboardTeam() {
        return Objects.requireNonNull(FkPI.getInstance().getTeamManager().nametag().scoreboard().getTeam(this.name), "scoreboard team");
    }

    public void balance(List<Team> teams, int playerPerTeams) {
        String p;
        if (this.players.size() >= playerPerTeams) {
            return;
        }
        for (Team t : teams) {
            while (t.getPlayers().size() - 1 > playerPerTeams && this.getPlayers().size() < playerPerTeams) {
                p = t.getPlayers().get(t.getPlayers().size() - 1);
                t.removePlayer(p);
                this.addPlayer(p);
            }
            if (this.players.size() < playerPerTeams) continue;
            break;
        }
        if (this.players.size() < playerPerTeams) {
            for (Team t : teams) {
                while (t.getPlayers().size() > playerPerTeams && this.getPlayers().size() < playerPerTeams) {
                    p = t.getPlayers().get(t.getPlayers().size() - 1);
                    t.removePlayer(p);
                    this.addPlayer(p);
                }
                if (this.getPlayers().size() - 1 >= playerPerTeams) continue;
                break;
            }
        }
    }

    public boolean equals(Object other) {
        return other instanceof Team && this.name.equals(((Team)other).getName());
    }

    @Override
    public void load(ConfigurationSection config) {
        this.players = config.getStringList("Members");
        this.setColor(Color.of(config.getString("Color")));
        if (!config.isConfigurationSection("Base")) {
            return;
        }
        this.base = new Base(this, null, 0, null, 0);
        this.base.load(config.getConfigurationSection("Base"));
        if (this.base.getCenter().getWorld() == null) {
            this.base = null;
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("Members", this.players);
        config.set("Color", (Object)this.color.getHexString());
        if (this.base == null || this.base.getCenter().getWorld() == null) {
            config.set("Base", null);
            return;
        }
        this.base.save(config.createSection("Base"));
    }

    public String toString() {
        return this.color.getChatColor() + this.getName();
    }
}

