/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.util;

import fr.devsylone.fallenkingdom.Fk;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.jetbrains.annotations.NotNull;

public class Color {
    private static final Set<Color> LEGACY_VALUES = new HashSet<Color>();
    public static final Color BLEU = new Color("bleu", "bleue", ChatColor.BLUE, DyeColor.BLUE, 0x5555FF);
    public static final Color CYAN = new Color("cyan", "cyan", ChatColor.DARK_AQUA, DyeColor.CYAN, 43690);
    public static final Color AQUA = new Color("aqua", "aqua", ChatColor.AQUA, DyeColor.LIGHT_BLUE, 0x55FFFF);
    public static final Color ROUGE = new Color("rouge", "rouge", ChatColor.RED, DyeColor.RED, 0xFF5555);
    public static final Color LIME = new Color("lime", "lime", ChatColor.GREEN, DyeColor.LIME, 0x55FF55);
    public static final Color VERT = new Color("vert", "verte", ChatColor.DARK_GREEN, DyeColor.GREEN, 43520);
    public static final Color VIOLET = new Color("violet", "violette", ChatColor.DARK_PURPLE, DyeColor.PURPLE, 0xAA00AA);
    public static final Color MAGENTA = new Color("magenta", "magenta", ChatColor.LIGHT_PURPLE, DyeColor.MAGENTA, 10958687);
    public static final Color ROSE = new Color("rose", "rose", ChatColor.LIGHT_PURPLE, DyeColor.PINK, 0xFF55FF);
    public static final Color ORANGE = new Color("orange", "orange", ChatColor.GOLD, DyeColor.ORANGE, 0xFFAA00);
    public static final Color JAUNE = new Color("jaune", "jaune", ChatColor.YELLOW, DyeColor.YELLOW, 0xFFFF55);
    public static final Color BLANC = new Color("blanc", "blanche", ChatColor.WHITE, DyeColor.WHITE, 0xFFFFFF);
    public static final Color NOIR = new Color("noir", "noire", ChatColor.BLACK, DyeColor.BLACK, 0);
    public static final Color GRIS = new Color("gris", "grise", ChatColor.GRAY, DyeColor.GRAY, 0xAAAAAA);
    private final String maleColor;
    private final String femColor;
    private final java.awt.Color value;
    private final ChatColor bukkitChatColor;
    private final net.md_5.bungee.api.ChatColor bungeeChatColor;
    private final DyeColor dyeColor;
    public static final int GENRE_F = 0;
    public static final int GENRE_M = 1;

    Color(String maleColor, String femColor, ChatColor chatColor, DyeColor dyeColor, int value) {
        this.maleColor = maleColor;
        this.femColor = femColor;
        this.value = new java.awt.Color(value);
        this.bukkitChatColor = chatColor;
        this.bungeeChatColor = net.md_5.bungee.api.ChatColor.class.isEnum() ? net.md_5.bungee.api.ChatColor.valueOf((String)chatColor.name()) : net.md_5.bungee.api.ChatColor.of((java.awt.Color)this.value);
        this.dyeColor = dyeColor;
        LEGACY_VALUES.add(this);
    }

    Color(Color base, java.awt.Color awtColor) {
        this.maleColor = base.maleColor;
        this.femColor = base.femColor;
        this.value = awtColor;
        this.bukkitChatColor = base.bukkitChatColor;
        this.bungeeChatColor = net.md_5.bungee.api.ChatColor.class.isEnum() ? base.bungeeChatColor : net.md_5.bungee.api.ChatColor.of((java.awt.Color)awtColor);
        this.dyeColor = base.dyeColor;
    }

    @NotNull
    public static Color of(String name) {
        if (name.startsWith("#") && name.length() == 7) {
            java.awt.Color awtColor = java.awt.Color.decode(name);
            Color nearest = Color.nearestTo(awtColor);
            return new Color(nearest, awtColor);
        }
        for (Color c : LEGACY_VALUES) {
            if (!c.isSame(name)) continue;
            return c;
        }
        return BLANC;
    }

    public boolean isSame(String name) {
        return this.maleColor.equalsIgnoreCase(name) || this.femColor.equalsIgnoreCase(name) || this.dyeColor.name().equalsIgnoreCase(name);
    }

    public String getGenredName(int genre) {
        if (Fk.getInstance().getLanguageManager().getLocale().getLanguage().equals("fr")) {
            return genre == 1 ? this.maleColor : this.femColor;
        }
        return this.dyeColor.name().toLowerCase().replace('_', ' ');
    }

    public net.md_5.bungee.api.ChatColor getChatColor() {
        return this.bungeeChatColor;
    }

    public ChatColor getBukkitChatColor() {
        return this.bukkitChatColor;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public String getHexString() {
        return String.format("#%06x", this.value.getRGB() & 0xFFFFFF);
    }

    public int getRGB() {
        return this.value.getRGB() & 0xFFFFFF;
    }

    public static Color[] values() {
        return LEGACY_VALUES.toArray(new Color[0]);
    }

    public static Color nearestTo(java.awt.Color any) {
        int matchedDistance = Integer.MAX_VALUE;
        Color match = null;
        for (Color potential : LEGACY_VALUES) {
            int distance = Color.distanceSquared(potential, any);
            if (distance < matchedDistance) {
                match = potential;
                matchedDistance = distance;
            }
            if (distance != 0) continue;
            break;
        }
        return match;
    }

    private static int distanceSquared(Color self, java.awt.Color other) {
        int rAvg = (self.value.getRed() + other.getRed()) / 2;
        int dR = self.value.getRed() - other.getRed();
        int dG = self.value.getGreen() - other.getGreen();
        int dB = self.value.getBlue() - other.getBlue();
        return (2 + rAvg / 256) * (dR * dR) + 4 * (dG * dG) + (2 + (255 - rAvg) / 256) * (dB * dB);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Color)) {
            return false;
        }
        Color color = (Color)o;
        return this.value.equals(color.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

