/*
 * Decompiled with CFR 0.152.
 */
package fr.devsylone.fkpi.util;

import com.google.common.base.Preconditions;
import fr.devsylone.fallenkingdom.version.Version;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XPotionData {
    private final PotionType type;
    private final boolean extended;
    private final boolean upgraded;
    private static final boolean VERSION1_8;
    private static final boolean SEPARATE_POTION_TYPES;

    public XPotionData(PotionType type, boolean extended, boolean upgraded) {
        Preconditions.checkNotNull((Object)type, (Object)"Potion Type must not be null");
        if (!SEPARATE_POTION_TYPES) {
            Preconditions.checkArgument((!upgraded || type.getMaxLevel() != 1 ? 1 : 0) != 0, (Object)"Potion Type is not upgradable");
        }
        Preconditions.checkArgument((!extended || !type.isInstant() ? 1 : 0) != 0, (Object)("Potion Type is not extendable" + type));
        Preconditions.checkArgument((!upgraded || !extended ? 1 : 0) != 0, (Object)"Potion cannot be both extended and upgraded");
        this.type = type;
        this.extended = extended;
        this.upgraded = upgraded;
    }

    public PotionType getType() {
        return this.type;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 23 * hash + (this.extended ? 1 : 0);
        hash = 23 * hash + (this.upgraded ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "XPotionData [type=" + this.type + ", extended=" + this.extended + ", upgraded=" + this.upgraded + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XPotionData)) {
            return false;
        }
        XPotionData other = (XPotionData)obj;
        return this.upgraded == other.upgraded && this.extended == other.extended && this.type == other.type;
    }

    @Nullable
    public static XPotionData fromItemStack(ItemStack potionItem) {
        if (potionItem == null) {
            return null;
        }
        ItemMeta itemMeta = potionItem.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return null;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        if (SEPARATE_POTION_TYPES) {
            PotionType type = meta.getBasePotionType();
            return type == null ? null : XPotionData.fromModernPotionType(type);
        }
        if (VERSION1_8) {
            Potion potion = Potion.fromItemStack((ItemStack)potionItem);
            return potion.getType() == null ? null : new XPotionData(potion.getType(), potion.hasExtendedDuration(), potion.getType().getMaxLevel() > 1 && potion.getLevel() > 1);
        }
        return XPotionData.fromPotionData(meta.getBasePotionData());
    }

    @NotNull
    public static XPotionData fromModernPotionType(@NotNull PotionType type) {
        return new XPotionData(type, type.getKey().getKey().startsWith("long_"), type.getKey().getKey().startsWith("strong_"));
    }

    public static XPotionData fromPotionData(PotionData data) {
        return data == null ? null : new XPotionData(data.getType(), data.isExtended(), data.isUpgraded());
    }

    @Nullable
    public static XPotionData fromProjectile(@NotNull Projectile projectile) {
        if (projectile instanceof ThrownPotion) {
            return XPotionData.fromItemStack(((ThrownPotion)projectile).getItem());
        }
        if (projectile instanceof TippedArrow) {
            return XPotionData.fromPotionData(((TippedArrow)projectile).getBasePotionData());
        }
        if (projectile instanceof Arrow) {
            if (SEPARATE_POTION_TYPES) {
                PotionType type = ((Arrow)projectile).getBasePotionType();
                if (type != null) {
                    return XPotionData.fromModernPotionType(type);
                }
            } else if (Version.VersionType.V1_16.isHigherOrEqual()) {
                return XPotionData.fromPotionData(((Arrow)projectile).getBasePotionData());
            }
        }
        return null;
    }

    public void applyTo(@NotNull ItemStack potionItem) {
        ItemMeta itemMeta = potionItem.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return;
        }
        if (VERSION1_8) {
            Potion potion = new Potion(this.type, this.upgraded ? 2 : 1, this.type.isInstant(), !this.type.isInstant() && this.extended);
            potion.apply(potionItem);
        } else {
            PotionMeta meta = (PotionMeta)itemMeta;
            if (SEPARATE_POTION_TYPES) {
                meta.setBasePotionType(this.type);
            } else {
                meta.setBasePotionData(new PotionData(this.type, this.extended, this.upgraded));
            }
            potionItem.setItemMeta((ItemMeta)meta);
        }
    }

    public static boolean isExtendable(PotionType type) {
        if (VERSION1_8) {
            return !type.isInstant();
        }
        return type.isExtendable();
    }

    public static boolean isUpgradable(PotionType type) {
        if (VERSION1_8) {
            return type.getMaxLevel() > 1;
        }
        return type.isUpgradeable();
    }

    static {
        boolean separatePotionTypes = false;
        try {
            PotionMeta.class.getMethod("setBasePotionType", PotionType.class);
            separatePotionTypes = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SEPARATE_POTION_TYPES = separatePotionTypes;
        VERSION1_8 = !separatePotionTypes && !Version.classExists("org.bukkit.potion.PotionData");
    }
}

