/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.response.impl;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.component.util.ComponentType;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.cumulus.response.impl.ResponseToResultGlue;
import org.geysermc.cumulus.response.result.ResultType;
import org.geysermc.cumulus.util.AbsentComponent;

public final class CustomFormResponseImpl
extends ResponseToResultGlue
implements CustomFormResponse {
    private final List<@Nullable Object> responses;
    private final JsonArray rawResponse;
    private final List<ComponentType> componentTypes;
    private int index = -1;
    private boolean includeLabels = false;

    private CustomFormResponseImpl(List<Object> responses, JsonArray rawResponse, List<ComponentType> componentTypes) {
        this.responses = Collections.unmodifiableList(responses);
        this.rawResponse = rawResponse;
        this.componentTypes = Collections.unmodifiableList(componentTypes);
    }

    @Deprecated
    public CustomFormResponseImpl(ResultType resultType) {
        super(resultType);
        this.responses = null;
        this.rawResponse = null;
        this.componentTypes = null;
    }

    public static @NonNull CustomFormResponse of(@NonNull List<Object> responses, @NonNull JsonArray rawResponse, @NonNull List<ComponentType> componentTypes) {
        Objects.requireNonNull(responses, "responses");
        Objects.requireNonNull(rawResponse, "rawResponse");
        Objects.requireNonNull(componentTypes, "componentTypes");
        return new CustomFormResponseImpl(responses, rawResponse, componentTypes);
    }

    @Override
    public @NonNull JsonArray getResponses() {
        return this.rawResponse;
    }

    @Override
    public @NonNull List<ComponentType> getComponentTypes() {
        return this.componentTypes;
    }

    private <T> @Nullable T nextOrAbsent(boolean includeLabels) {
        if (!this.hasNext()) {
            return null;
        }
        while (++this.index < this.responses.size()) {
            Object response = this.responses.get(this.index);
            if (response == null && !includeLabels) continue;
            return (T)response;
        }
        return null;
    }

    @Override
    public <T> @Nullable T next(boolean includeLabels) {
        T next = this.nextOrAbsent(includeLabels);
        if (next instanceof AbsentComponent) {
            return null;
        }
        return next;
    }

    @Override
    public void skip(int amount) {
        Preconditions.checkArgument((amount >= 1 ? 1 : 0) != 0, (Object)"amount");
        this.index += amount;
    }

    @Override
    public void skip() {
        this.skip(1);
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    @Override
    public void index(int index) {
        Preconditions.checkArgument((index >= -1 ? 1 : 0) != 0, (Object)"index");
        this.index = index;
    }

    @Override
    public void includeLabels(boolean includeLabels) {
        this.includeLabels = includeLabels;
    }

    @Override
    public boolean hasNext() {
        return this.responses.size() > this.index + 1;
    }

    @Override
    public boolean isPresent() {
        return this.responses.size() > this.index && this.responses.get(this.index) != null;
    }

    @Override
    public boolean isNextPresent() {
        return this.hasNext() && this.responses.get(this.index + 1) != null;
    }

    private <T> T nextOrAbsent() {
        return this.nextOrAbsent(this.includeLabels);
    }

    @Override
    public <T> @Nullable T next() {
        return this.next(this.includeLabels);
    }

    @Override
    public int asDropdown() {
        Object next = this.nextOrAbsent();
        if (next instanceof AbsentComponent) {
            return 0;
        }
        if (next instanceof Integer) {
            return (Integer)next;
        }
        throw this.wrongType(this.index, "dropdown");
    }

    @Override
    public @Nullable String asInput() {
        Object next = this.nextOrAbsent();
        if (next instanceof AbsentComponent) {
            return null;
        }
        if (next instanceof String) {
            return (String)next;
        }
        throw this.wrongType(this.index, "input");
    }

    @Override
    public float asSlider() {
        Object next = this.nextOrAbsent();
        if (next instanceof AbsentComponent) {
            return 0.0f;
        }
        if (next instanceof Float) {
            return ((Float)next).floatValue();
        }
        throw this.wrongType(this.index, "slider");
    }

    @Override
    public int asStepSlider() {
        Object next = this.nextOrAbsent();
        if (next instanceof AbsentComponent) {
            return 0;
        }
        if (next instanceof Integer) {
            return (Integer)next;
        }
        throw this.wrongType(this.index, "step slider");
    }

    @Override
    public boolean asToggle() {
        Object next = this.nextOrAbsent();
        if (next instanceof AbsentComponent) {
            return false;
        }
        if (next instanceof Boolean) {
            return (Boolean)next;
        }
        throw this.wrongType(this.index, "toggle");
    }

    @Override
    public @NonNull JsonPrimitive get(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index");
        try {
            return this.rawResponse.get(index).getAsJsonPrimitive();
        }
        catch (IllegalStateException exception) {
            throw this.wrongType(index, "a primitive");
        }
    }

    private <T> @Nullable T valueOrAbsent(int index) throws IllegalArgumentException, ClassCastException {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index");
        if (index >= this.responses.size()) {
            throw new IllegalArgumentException("Requested an higher index than there are components");
        }
        return (T)this.responses.get(index);
    }

    @Override
    public <T> @Nullable T valueAt(int index) throws IllegalArgumentException, ClassCastException {
        T response = this.valueOrAbsent(index);
        if (response instanceof AbsentComponent) {
            return null;
        }
        return response;
    }

    @Override
    public int asDropdown(int index) {
        Object next = this.valueOrAbsent(index);
        if (next instanceof AbsentComponent) {
            return 0;
        }
        if (next instanceof Integer) {
            return (Integer)next;
        }
        throw this.wrongType(index, "dropdown");
    }

    @Override
    public @Nullable String asInput(int index) {
        Object next = this.valueOrAbsent(index);
        if (next instanceof AbsentComponent) {
            return null;
        }
        if (next instanceof String) {
            return (String)next;
        }
        throw this.wrongType(index, "input");
    }

    @Override
    public float asSlider(int index) {
        Object next = this.valueOrAbsent(index);
        if (next instanceof AbsentComponent) {
            return 0.0f;
        }
        if (next instanceof Float) {
            return ((Float)next).floatValue();
        }
        throw this.wrongType(index, "slider");
    }

    @Override
    public int asStepSlider(int index) {
        Object next = this.valueOrAbsent(index);
        if (next instanceof AbsentComponent) {
            return 0;
        }
        if (next instanceof Integer) {
            return (Integer)next;
        }
        throw this.wrongType(index, "step slider");
    }

    @Override
    public boolean asToggle(int index) {
        Object next = this.valueOrAbsent(index);
        if (next instanceof AbsentComponent) {
            return false;
        }
        if (next instanceof Boolean) {
            return (Boolean)next;
        }
        throw this.wrongType(index, "toggle");
    }

    @Override
    public int getDropdown(@NonNegative int index) {
        return this.asDropdown(index);
    }

    @Override
    public @Nullable String getInput(@NonNegative int index) {
        return this.asInput(index);
    }

    @Override
    public float getSlider(@NonNegative int index) {
        return this.asSlider(index);
    }

    @Override
    public int getStepSlide(@NonNegative int index) {
        return this.asStepSlider(index);
    }

    @Override
    public boolean getToggle(@NonNegative int index) {
        return this.asToggle(index);
    }

    private IllegalStateException wrongType(int index, String expected) {
        Object response = this.responses.get(index);
        String unexpected = response == null ? "label" : response.toString();
        return new IllegalStateException(String.format("Expected %s on %s, got %s", expected, index, unexpected));
    }
}

