/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public interface GeyserCommandSource
extends CommandSource {
    @Override
    default public String locale() {
        return GeyserLocale.getDefaultLocale();
    }

    default public void sendMessage(Component message) {
        this.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
    }

    default public void sendLocaleString(String key, Object ... values) {
        this.sendMessage(GeyserLocale.getPlayerLocaleString(key, this.locale(), values));
    }

    default public void sendLocaleString(String key) {
        this.sendMessage(GeyserLocale.getPlayerLocaleString(key, this.locale()));
    }

    @Override
    default public @Nullable GeyserSession connection() {
        UUID uuid = this.playerUuid();
        if (uuid == null) {
            return null;
        }
        return GeyserImpl.getInstance().connectionByUuid(uuid);
    }

    default public Object handle() {
        return this;
    }
}

