/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.network.BedrockListener;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.configuration.ExcludePlatform;
import org.geysermc.geyser.configuration.PluginSpecific;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.interfaces.meta.defaults.DefaultBoolean;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.interfaces.meta.defaults.DefaultNumeric;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.interfaces.meta.defaults.DefaultString;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.interfaces.meta.range.NumericRange;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.objectmapping.meta.Comment;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.util.CooldownUtils;

@ConfigSerializable
public interface GeyserConfig {
    @Comment(value="Network settings for the Bedrock listener")
    public BedrockConfig bedrock();

    @Comment(value="Network settings for the Java server connection")
    public JavaConfig java();

    @Comment(value="MOTD settings")
    public MotdConfig motd();

    @Comment(value="Gameplay options that affect Bedrock players")
    public GameplayConfig gameplay();

    @Comment(value="The default locale if we don't have the one the client requested. If set to \"system\", the system's language will be used.")
    @DefaultString(value="system")
    public @NonNull String defaultLocale();

    @Comment(value="Whether player IP addresses will be logged by the server.")
    @DefaultBoolean(value=true)
    public boolean logPlayerIpAddresses();

    @Comment(value="For online mode authentication type only.\nStores a list of Bedrock player usernames that should have their Java Edition account saved after login.\nThis saves a token that can be reused to authenticate the player later. This does not save emails or passwords,\nbut you should still be cautious when adding to this list and giving others access to this Geyser instance's files.\nRemoving a name from this list will delete its cached login information on the next Geyser startup.\nThe file that tokens will be saved in is in the same folder as this config, named \"saved-refresh-tokens.json\".")
    default public List<String> savedUserLogins() {
        return List.of("ThisExampleUsernameShouldBeLongEnoughToNeverBeAnXboxUsername", "ThisOtherExampleUsernameShouldAlsoBeLongEnough");
    }

    @Comment(value="For online mode authentication type only.\nSpecify how many seconds to wait while user authorizes Geyser to access their Microsoft account.\nUser is allowed to disconnect from the server during this period.")
    @DefaultNumeric(value=120L)
    public int pendingAuthenticationTimeout();

    @Comment(value="Whether to alert the console and operators that a new Geyser version is available that supports a Bedrock version\nthat this Geyser version does not support. It's recommended to keep this option enabled, as many Bedrock platforms\nauto-update.")
    @DefaultBoolean(value=true)
    public boolean notifyOnNewBedrockUpdate();

    @Comment(value="Advanced configuration options. These usually do not need modifications.")
    public AdvancedConfig advanced();

    @Comment(value="bStats is a stat tracker that is entirely anonymous and tracks only basic information\nabout Geyser, such as how many people are online, how many servers are using Geyser,\nwhat OS is being used, etc. You can learn more about bStats here: https://bstats.org/.\nhttps://bstats.org/plugin/server-implementation/GeyserMC")
    @DefaultBoolean(value=true)
    @ExcludePlatform(platforms={"BungeeCord", "Spigot", "Velocity"})
    public boolean enableMetrics();

    @Comment(value="The bstats metrics uuid. Do not touch!")
    @ExcludePlatform(platforms={"BungeeCord", "Spigot", "Velocity"})
    default public UUID metricsUuid() {
        return UUID.randomUUID();
    }

    @Comment(value="If debug messages should be sent through console")
    public boolean debugMode();

    @Comment(value="Do not change!")
    default public int configVersion() {
        return 5;
    }

    @ConfigSerializable
    public static interface AdvancedConfig {
        @Comment(value="Specify how many days player skin images will be cached to disk to save downloading them from the internet.\nA value of 0 is disabled. (Default: 0)")
        public int cacheImages();

        @Comment(value="Geyser updates the Scoreboard after every Scoreboard packet, but when Geyser tries to handle\na lot of scoreboard packets per second, this can cause serious lag.\nThis option allows you to specify after how many Scoreboard packets per seconds\nthe Scoreboard updates will be limited to four updates per second.")
        @DefaultNumeric(value=20L)
        public int scoreboardPacketThreshold();

        @Comment(value="Whether Geyser should send team names in command suggestions.\nDisable this if you have a lot of teams used that you don't need as suggestions.")
        @DefaultBoolean(value=true)
        public boolean addTeamSuggestions();

        @Comment(value="A list of remote resource pack urls to send to the Bedrock client for downloading.\nThe Bedrock client is very picky about how these are delivered - please see our wiki page for further info: https://geysermc.org/wiki/geyser/packs/\n")
        default public List<String> resourcePackUrls() {
            return Collections.emptyList();
        }

        @Comment(value="Floodgate uses encryption to ensure use from authorized sources.\nThis should point to the public key generated by Floodgate (BungeeCord, Spigot or Velocity)\nYou can ignore this when not using Floodgate.\nIf you're using a plugin version of Floodgate on the same server, the key will automatically be picked up from Floodgate.")
        @DefaultString(value="key.pem")
        public String floodgateKeyFile();

        @Comment(value="Advanced networking options for the Geyser to Java server connection")
        public AdvancedJavaConfig java();

        @Comment(value="Advanced networking options for Geyser's Bedrock listener")
        public AdvancedBedrockConfig bedrock();
    }

    @ConfigSerializable
    public static interface AdvancedJavaConfig {
        @Comment(value="Whether to enable HAPROXY protocol when connecting to the Java server.\nThis is useful only when:\n1) Your Java server supports HAPROXY protocol (it probably doesn't)\n2) You run Velocity or BungeeCord with the option enabled in the proxy's main config.\nIF YOU DON'T KNOW WHAT THIS IS, DON'T TOUCH IT!")
        public boolean useHaproxyProtocol();

        @Comment(value="Whether to connect directly into the Java server without creating a TCP connection.\nThis should only be disabled if a plugin that interfaces with packets or the network does not work correctly with Geyser.\nIf enabled, the remote address and port sections are ignored.\nIf disabled, expect performance decrease and latency increase.\n")
        @DefaultBoolean(value=true)
        @PluginSpecific
        public boolean useDirectConnection();

        @Comment(value="Whether Geyser should attempt to disable packet compression (from the Java Server to Geyser) for Bedrock players.\nThis should be a benefit as there is no need to compress data when Java packets aren't being handled over the network.\nThis requires use-direct-connection to be true.\n")
        @DefaultBoolean(value=true)
        @PluginSpecific
        public boolean disableCompression();
    }

    @ConfigSerializable
    public static interface AdvancedBedrockConfig {
        @Comment(value="The port to broadcast to Bedrock clients with the MOTD that they should use to connect to the server.\nA value of 0 will broadcast the port specified above.\nDO NOT change this unless Geyser runs on a different port than the one that is used to connect.")
        @DefaultNumeric(value=0L)
        @NumericRange(from=0L, to=65535L)
        public int broadcastPort();

        public void broadcastPort(int var1);

        @Comment(value="How much to compress network traffic to the Bedrock client. The higher the number, the more CPU usage used, but\nthe smaller the bandwidth used. Does not have any effect below -1 or above 9. Set to -1 to disable.")
        @DefaultNumeric(value=6L)
        @NumericRange(from=-1L, to=9L)
        public int compressionLevel();

        @Comment(value="Whether to expect HAPROXY protocol for connecting Bedrock clients.\nThis is useful only when you are running a UDP reverse proxy in front of your Geyser instance.\nIF YOU DON'T KNOW WHAT THIS IS, DON'T TOUCH IT!")
        @DefaultBoolean
        public boolean useHaproxyProtocol();

        @Comment(value="A list of allowed HAPROXY protocol speaking proxy IP addresses/subnets. Only effective when \"use-proxy-protocol\" is enabled, and\nshould really only be used when you are not able to use a proper firewall (usually true with shared hosting providers etc.).\nKeeping this list empty means there is no IP address whitelist.\nIP addresses, subnets, and links to plain text files are supported.")
        default public List<String> haproxyProtocolWhitelistedIps() {
            return Collections.emptyList();
        }

        @Comment(value="The internet supports a maximum MTU of 1492 but could cause issues with packet fragmentation.\n1400 is the default.")
        @DefaultNumeric(value=1400L)
        public int mtu();

        @Comment(value="This option disables the auth step Geyser performs for connecting Bedrock players.\nIt can be used to allow connections from ProxyPass and WaterdogPE. In these cases, make sure that users\ncannot directly connect to this Geyser instance. See https://www.spigotmc.org/wiki/firewall-guide/ for\nassistance - and use UDP instead of TCP.\nDisabling Bedrock authentication for other use-cases is NOT SUPPORTED, as it allows anyone to spoof usernames, and is therefore a security risk.\nAll Floodgate functionality (including skin uploading and account linking) will also not work when this option is disabled.")
        @DefaultBoolean(value=true)
        public boolean validateBedrockLogin();
    }

    @ConfigSerializable
    public static interface GameplayConfig {
        @Comment(value="The server name that will be sent to Minecraft: Bedrock Edition clients. This is visible in both the pause menu and the settings menu.")
        @DefaultString(value="Geyser")
        public String serverName();

        @Comment(value="Allow a fake cooldown indicator to be sent. Bedrock players otherwise do not see a cooldown as they still use 1.8 combat.\nPlease note: if the cooldown is enabled, some users may see a black box during the cooldown sequence, like below:\nhttps://geysermc.org/img/external/cooldown_indicator.png\nThis can be disabled by going into Bedrock settings under the accessibility tab and setting \"Text Background Opacity\" to 0\nThis setting can be set to \"title\", \"actionbar\" or \"false\"")
        default public CooldownUtils.CooldownType showCooldown() {
            return CooldownUtils.CooldownType.TITLE;
        }

        @Comment(value="Bedrock clients can freeze when opening up the command prompt for the first time if given a lot of commands.\nDisabling this will prevent command suggestions from being sent and solve freezing for Bedrock clients.")
        @DefaultBoolean(value=true)
        public boolean commandSuggestions();

        @Comment(value="Controls if coordinates are shown to players.")
        @DefaultBoolean(value=true)
        public boolean showCoordinates();

        @Comment(value="Whether Bedrock players are blocked from performing their scaffolding-style bridging.")
        public boolean disableBedrockScaffolding();

        @Comment(value="Bedrock prevents building and displaying blocks above Y127 in the Nether.\nThis config option works around that by changing the Nether dimension ID to the End ID.\nThe main downside to this is that the entire Nether will have the same red fog rather than having different fog for each biome.")
        public boolean netherRoofWorkaround();

        @Comment(value="Whether to show Bedrock Edition emotes to other Bedrock Edition players.\n")
        @DefaultBoolean(value=true)
        public boolean emotesEnabled();

        @Comment(value="Which item to use to mark unavailable slots in a Bedrock player inventory. Examples of this are the 2x2 crafting grid while in creative,\nor custom inventory menus with sizes different from the usual 3x9. A barrier block is the default item.\nThis config option can be set to any Bedrock item identifier. If you want to set this to a custom item, make sure that you specify the item in the following format: \"geyser_custom:<mapping-name>\"\n")
        @DefaultString(value="minecraft:barrier")
        public String unusableSpaceBlock();

        @Comment(value="Whether to add any items and blocks which normally does not exist in Bedrock Edition.\nThis should only need to be disabled if using a proxy that does not use the \"transfer packet\" style of server switching.\nIf this is disabled, furnace minecart items will be mapped to hopper minecart items.\nGeyser's block, item, and skull mappings systems will also be disabled.\nThis option requires a restart of Geyser in order to change its setting.")
        @DefaultBoolean(value=true)
        public boolean enableCustomContent();

        @Comment(value="Force clients to load all resource packs if there are any.\nIf set to false, it allows the user to connect to the server even if they don't\nwant to download the resource packs.")
        @DefaultBoolean(value=true)
        public boolean forceResourcePacks();

        @Comment(value="Whether to automatically serve a resource pack that is required for some Geyser features to all connecting Bedrock players.\nIf enabled, force-resource-packs will be enabled.")
        @DefaultBoolean(value=true)
        public boolean enableIntegratedPack();

        @Comment(value="Whether to forward player ping to the server. While enabling this will allow Bedrock players to have more accurate\nping, it may also cause players to time out more easily.")
        public boolean forwardPlayerPing();

        @Comment(value="Allows Xbox achievements to be unlocked.\nIf a player types in an unknown command, they will receive a message that states cheats are disabled.\nOtherwise, commands work as expected.")
        public boolean xboxAchievementsEnabled();

        @Comment(value="The maximum number of custom skulls to be displayed per player. Increasing this may decrease performance on weaker devices.\nA value of 0 will disable all custom skulls.\nSetting this to -1 will cause all custom skulls to be displayed regardless of distance or number.")
        @DefaultNumeric(value=128L)
        public int maxVisibleCustomSkulls();

        @Comment(value="The radius in blocks around the player in which custom skulls are displayed.")
        @DefaultNumeric(value=32L)
        public int customSkullRenderDistance();
    }

    @ConfigSerializable
    public static interface MotdConfig {
        @Comment(value="The MOTD that will be broadcasted to Minecraft: Bedrock Edition clients. This is irrelevant if \"passthrough-motd\" is set to true.\nIf either of these are empty, the respective string will default to \"Geyser\"")
        @DefaultString(value="Geyser")
        public String primaryMotd();

        @DefaultString(value="Another Geyser server.")
        public String secondaryMotd();

        @Comment(value="Whether Geyser should relay the MOTD from the Java server to Bedrock players.")
        @DefaultBoolean(value=true)
        public boolean passthroughMotd();

        @Comment(value="Maximum amount of players that can connect.\nThis is only visual, and is only applied if passthrough-motd is disabled.")
        @DefaultNumeric(value=100L)
        public int maxPlayers();

        @Comment(value="Whether to relay the player count and max players from the Java server to Bedrock players.")
        @DefaultBoolean(value=true)
        public boolean passthroughPlayerCounts();

        @Comment(value="Whether to use server API methods to determine the Java server's MOTD and ping passthrough.\nThere is no need to disable this unless your MOTD or player count does not appear properly.")
        @DefaultBoolean(value=true)
        @PluginSpecific
        public boolean integratedPingPassthrough();

        @Comment(value="How often to ping the Java server to refresh MOTD and player count, in seconds.")
        @DefaultNumeric(value=3L)
        public int pingPassthroughInterval();
    }

    @ConfigSerializable
    public static interface JavaConfig
    extends RemoteServer {
        public void address(String var1);

        public void port(int var1);

        @Override
        @Comment(value="What type of authentication Bedrock players will be checked against when logging into the Java server.\nCan be \"floodgate\" (see https://wiki.geysermc.org/floodgate/), \"online\", or \"offline\".")
        default public @NonNull AuthType authType() {
            return AuthType.ONLINE;
        }

        public void authType(AuthType var1);

        public boolean forwardHostname();

        @Override
        default public String minecraftVersion() {
            return GameProtocol.getJavaMinecraftVersion();
        }

        @Override
        default public int protocolVersion() {
            return GameProtocol.getJavaProtocolVersion();
        }

        @Override
        default public boolean resolveSrv() {
            return false;
        }
    }

    @ConfigSerializable
    public static interface BedrockConfig
    extends BedrockListener {
        @Override
        @Comment(value="The IP address that Geyser will bind on to listen for incoming Bedrock connections.\nGenerally, you should only change this if you want to limit what IPs can connect to your server.")
        @DefaultString(value="0.0.0.0")
        @AsteriskSerializer.Asterisk
        public @NonNull String address();

        @Override
        @Comment(value="The port that will Geyser will listen on for incoming Bedrock connections.\nSince Minecraft: Bedrock Edition uses UDP, this port must allow UDP traffic.")
        @DefaultNumeric(value=19132L)
        @NumericRange(from=0L, to=65535L)
        public int port();

        @Comment(value="Some hosting services change your Java port everytime you start the server and require the same port to be used for Bedrock.\nThis option makes the Bedrock port the same as the Java port every time you start the server.")
        @DefaultBoolean
        @PluginSpecific
        public boolean cloneRemotePort();

        public void address(String var1);

        public void port(int var1);

        @Override
        default public int broadcastPort() {
            return GeyserImpl.getInstance().config().advanced().bedrock().broadcastPort();
        }

        @Override
        default public String primaryMotd() {
            return GeyserImpl.getInstance().config().motd().primaryMotd();
        }

        @Override
        default public String secondaryMotd() {
            return GeyserImpl.getInstance().config().motd().secondaryMotd();
        }

        @Override
        default public String serverName() {
            return GeyserImpl.getInstance().config().gameplay().serverName();
        }
    }
}

