/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.recipe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ProvidesTrimMaterial;

public final class TrimRecipe {
    private static final Map<ProvidesTrimMaterial, Item> trimMaterialProviders = new HashMap<ProvidesTrimMaterial, Item>();
    public static final String ID = "minecraft:smithing_armor_trim";
    public static final ItemDescriptorWithCount BASE = TrimRecipe.tagDescriptor("minecraft:trimmable_armors");
    public static final ItemDescriptorWithCount ADDITION = TrimRecipe.tagDescriptor("minecraft:trim_materials");
    public static final ItemDescriptorWithCount TEMPLATE = TrimRecipe.tagDescriptor("minecraft:trim_templates");

    public static TrimMaterial readTrimMaterial(RegistryEntryContext context) {
        String key = context.id().asMinimalString();
        Component description = MessageTranslator.componentFromNbtTag(context.data().get("description"));
        String legacy = MessageTranslator.convertMessage(Component.space().style(description.style()));
        String color = legacy.isBlank() ? "\u00a7f" : legacy.substring(2).trim();
        int networkId = context.getNetworkId(context.id());
        ItemMapping trimItem = null;
        if (context.session().isPresent()) {
            for (ProvidesTrimMaterial provider : TrimRecipe.materialProviders().keySet()) {
                Holder<ArmorTrim.TrimMaterial> materialHolder = provider.materialHolder();
                if (!context.id().equals(provider.materialLocation()) && (materialHolder == null || !materialHolder.isId() || materialHolder.id() != networkId)) continue;
                trimItem = context.session().get().getItemMappings().getMapping(TrimRecipe.materialProviders().get(provider));
                break;
            }
        }
        if (trimItem == null) {
            GeyserImpl.getInstance().getLogger().debug("Unable to found trim material item for material " + String.valueOf(context.id()));
            trimItem = ItemMapping.AIR;
        }
        return new TrimMaterial(key, color, trimItem.getBedrockIdentifier());
    }

    public static TrimPattern readTrimPattern(RegistryEntryContext context) {
        String key = context.id().asMinimalString();
        String identifier = context.id().asString() + "_armor_trim_smithing_template";
        ItemMapping itemMapping = ItemMapping.AIR;
        if (context.session().isPresent() && (itemMapping = context.session().get().getItemMappings().getMapping(identifier)) == null) {
            GeyserImpl.getInstance().getLogger().debug("Unable to found trim pattern item for pattern " + String.valueOf(context.id()));
            itemMapping = ItemMapping.AIR;
        }
        return new TrimPattern(itemMapping.getBedrockIdentifier(), key);
    }

    private TrimRecipe() {
    }

    private static Map<ProvidesTrimMaterial, Item> materialProviders() {
        if (trimMaterialProviders.isEmpty()) {
            for (Item item : (List)Registries.JAVA_ITEMS.get()) {
                ProvidesTrimMaterial provider = item.getComponent(DataComponentTypes.PROVIDES_TRIM_MATERIAL);
                if (provider == null) continue;
                trimMaterialProviders.put(provider, item);
            }
        }
        return trimMaterialProviders;
    }

    private static ItemDescriptorWithCount tagDescriptor(String tag) {
        return new ItemDescriptorWithCount(new ItemTagDescriptor(tag), 1);
    }
}

