/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Color;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.skin.Cape;
import org.geysermc.geyser.api.skin.Skin;
import org.geysermc.geyser.api.skin.SkinData;
import org.geysermc.geyser.api.skin.SkinGeometry;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class SkinManager {
    static final String GEOMETRY = new String(FileUtils.readAllBytes("bedrock/geometries/geo.json"), StandardCharsets.UTF_8);

    public static PlayerListPacket.Entry buildCachedEntry(GeyserSession session, PlayerEntity playerEntity) {
        GameProfileData data = GameProfileData.from(playerEntity);
        Skin skin = null;
        Cape cape = null;
        SkinGeometry geometry = SkinGeometry.WIDE;
        if (data != null) {
            skin = SkinProvider.getCachedSkin(data.skinUrl());
            cape = SkinProvider.getCachedCape(data.capeUrl());
            SkinGeometry skinGeometry = geometry = data.isAlex() ? SkinGeometry.SLIM : SkinGeometry.WIDE;
        }
        if (skin == null || cape == null) {
            SkinData fallbackSkinData = SkinProvider.determineFallbackSkinData(playerEntity.getUuid());
            if (skin == null) {
                skin = fallbackSkinData.skin();
                geometry = fallbackSkinData.geometry();
            }
            if (cape == null) {
                cape = fallbackSkinData.cape();
            }
        }
        return SkinManager.buildEntryManually(session, playerEntity.getUuid(), playerEntity.getUsername(), playerEntity.getGeyserId(), skin, cape, geometry);
    }

    public static PlayerListPacket.Entry buildEntryManually(GeyserSession session, UUID uuid, String username, long geyserId, Skin skin, Cape cape, SkinGeometry geometry) {
        SerializedSkin serializedSkin = SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry);
        String xuid = "";
        GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (playerSession != null) {
            xuid = playerSession.getAuthData().xuid();
        }
        PlayerListPacket.Entry entry = session.getPlayerEntity().getUuid().equals(uuid) ? new PlayerListPacket.Entry(session.getAuthData().uuid()) : new PlayerListPacket.Entry(uuid);
        entry.setName(username);
        entry.setEntityId(geyserId);
        entry.setSkin(serializedSkin);
        entry.setXuid(xuid);
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        entry.setColor(Color.BLACK);
        return entry;
    }

    public static void sendSkinPacket(GeyserSession session, PlayerEntity entity, SkinData skinData) {
        Skin skin = skinData.skin();
        Cape cape = skinData.cape();
        SkinGeometry geometry = skinData.geometry();
        if (entity.getUuid().equals(session.getPlayerEntity().getUuid())) {
            PlayerListPacket.Entry updatedEntry = SkinManager.buildEntryManually(session, entity.getUuid(), entity.getUsername(), entity.getGeyserId(), skin, cape, geometry);
            PlayerListPacket playerAddPacket = new PlayerListPacket();
            playerAddPacket.setAction(PlayerListPacket.Action.ADD);
            playerAddPacket.getEntries().add(updatedEntry);
            session.sendUpstreamPacket(playerAddPacket);
        } else {
            PlayerSkinPacket packet = new PlayerSkinPacket();
            packet.setUuid(entity.getUuid());
            packet.setOldSkinName("");
            packet.setNewSkinName(skin.textureUrl());
            packet.setSkin(SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry));
            packet.setTrustedSkin(true);
            session.sendUpstreamPacket(packet);
        }
    }

    private static SerializedSkin getSkin(GeyserSession session, String skinId, Skin skin, Cape cape, SkinGeometry geometry) {
        return SerializedSkin.builder().skinId(skinId).skinResourcePatch(geometry.geometryName()).skinData(ImageData.of(skin.skinData())).capeData(ImageData.of(cape.capeData())).geometryData(geometry.geometryData().isBlank() ? GEOMETRY : geometry.geometryData()).premium(true).capeId(cape.capeId()).fullSkinId(skinId).geometryDataEngineVersion(session.getClientData().getGameVersion()).build();
    }

    public static void requestAndHandleSkinAndCape(PlayerEntity entity, GeyserSession session, Consumer<SkinProvider.SkinAndCape> skinAndCapeConsumer) {
        SkinProvider.requestSkinData(entity, session).whenCompleteAsync((skinData, throwable) -> {
            if (skinData == null) {
                if (skinAndCapeConsumer != null) {
                    skinAndCapeConsumer.accept(null);
                }
                return;
            }
            if (skinData.geometry() != null) {
                SkinManager.sendSkinPacket(session, entity, skinData);
            }
            if (skinAndCapeConsumer != null) {
                skinAndCapeConsumer.accept(new SkinProvider.SkinAndCape(skinData.skin(), skinData.cape()));
            }
        });
    }

    public static void handleBedrockSkin(PlayerEntity playerEntity, BedrockClientData clientData) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser.getConfig().isDebugMode()) {
            geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.register", playerEntity.getUsername(), playerEntity.getUuid()));
        }
        try {
            byte[] skinBytes = Base64.getDecoder().decode(clientData.getSkinData().getBytes(StandardCharsets.UTF_8));
            byte[] capeBytes = clientData.getCapeData();
            byte[] geometryNameBytes = Base64.getDecoder().decode(clientData.getGeometryName().getBytes(StandardCharsets.UTF_8));
            byte[] geometryBytes = Base64.getDecoder().decode(clientData.getGeometryData().getBytes(StandardCharsets.UTF_8));
            if (skinBytes.length <= 65536 && !clientData.isPersonaSkin()) {
                SkinProvider.storeBedrockSkin(playerEntity.getUuid(), clientData.getSkinId(), skinBytes);
                SkinProvider.storeBedrockGeometry(playerEntity.getUuid(), geometryNameBytes, geometryBytes);
            } else if (geyser.getConfig().isDebugMode()) {
                geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.fail", playerEntity.getUsername()));
                geyser.getLogger().debug("The size of '" + playerEntity.getUsername() + "' skin is: " + clientData.getSkinImageWidth() + "x" + clientData.getSkinImageHeight());
            }
            if (!clientData.getCapeId().equals("")) {
                SkinProvider.storeBedrockCape(clientData.getCapeId(), capeBytes);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Failed to cache skin for bedrock user (" + playerEntity.getUsername() + "): ", e);
        }
    }

    public record GameProfileData(String skinUrl, String capeUrl, boolean isAlex) {
        private static final String DEFAULT_FLOODGATE_STEVE = "https://textures.minecraft.net/texture/31f477eb1a7beee631c2ca64d06f8f68fa93a3386d04452ab27f43acdf1b60cb";

        public static @Nullable GameProfileData from(NbtMap tag) {
            NbtMap properties = tag.getCompound("Properties", null);
            if (properties == null) {
                return null;
            }
            List textures = properties.getList("textures", NbtType.COMPOUND);
            if (textures.isEmpty()) {
                return null;
            }
            String skinDataValue = ((NbtMap)textures.get(0)).getString("Value", null);
            if (skinDataValue == null) {
                return null;
            }
            try {
                return GameProfileData.loadFromJson(skinDataValue);
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for tag " + String.valueOf(tag));
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData from(PlayerEntity entity) {
            String texturesProperty = entity.getTexturesProperty();
            if (texturesProperty == null) {
                return null;
            }
            try {
                return GameProfileData.loadFromJson(texturesProperty);
            }
            catch (Exception exception) {
                if (entity instanceof SkullPlayerEntity) {
                    SkullPlayerEntity skullEntity = (SkullPlayerEntity)entity;
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for skull at " + String.valueOf(skullEntity.getSkullPosition()) + " with Value: " + texturesProperty);
                } else {
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for " + entity.getUsername() + " with Value: " + texturesProperty);
                }
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData loadFromJson(String encodedJson) throws IOException, IllegalArgumentException {
            JsonNode capeUrlNode;
            JsonNode skinObject;
            try {
                skinObject = GeyserImpl.JSON_MAPPER.readTree(new String(Base64.getDecoder().decode(encodedJson), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                GeyserImpl.getInstance().getLogger().debug("Invalid base64 encoded skin entry: " + encodedJson);
                return null;
            }
            JsonNode textures = skinObject.get("textures");
            if (textures == null) {
                return null;
            }
            JsonNode skinTexture = textures.get("SKIN");
            if (skinTexture == null) {
                return null;
            }
            JsonNode skinUrlNode = skinTexture.get("url");
            if (skinUrlNode == null || !skinUrlNode.isTextual()) {
                return null;
            }
            String skinUrl = skinUrlNode.asText().replace("http://", "https://");
            if (DEFAULT_FLOODGATE_STEVE.equals(skinUrl)) {
                return null;
            }
            boolean isAlex = skinTexture.has("metadata");
            String capeUrl = null;
            JsonNode capeTexture = textures.get("CAPE");
            if (capeTexture != null && (capeUrlNode = capeTexture.get("url")) != null && capeUrlNode.isTextual()) {
                capeUrl = capeUrlNode.asText().replace("http://", "https://");
            }
            return new GameProfileData(skinUrl, capeUrl, isAlex);
        }
    }
}

