/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.DisplayBaseEntity;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.jetbrains.annotations.Nullable;

public class TextDisplayEntity
extends DisplayBaseEntity {
    private int lineCount;

    public TextDisplayEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position.add(0.0f, definition.offset(), 0.0f), motion, yaw, pitch, headYaw);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, boolean isOnGround) {
        super.moveRelative(relX, relY + (double)this.definition.offset(), relZ, yaw, pitch, isOnGround);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position.add(Vector3f.from(0.0f, this.definition.offset(), 0.0f)), yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.HITBOX, NbtMap.EMPTY);
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.0f));
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
    }

    public void setText(EntityMetadata<Component, ?> entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.NAME, MessageTranslator.convertMessage(entityMetadata.getValue(), this.session.locale()));
        this.calculateLineCount(entityMetadata.getValue());
    }

    private void calculateLineCount(@Nullable Component text) {
        if (text == null) {
            this.lineCount = 0;
            return;
        }
        this.lineCount = PlainTextComponentSerializer.plainText().serialize(text).split("\n").length;
    }

    public int getLineCount() {
        return this.lineCount;
    }
}

