/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.bukkit.parser;

import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.bukkit.BukkitCaptionKeys;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.caption.CaptionVariable;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.component.CommandComponent;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.context.CommandInput;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.exception.parsing.ParserException;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ArgumentParser;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.parser.ParserDescriptor;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class WorldParser<C>
implements ArgumentParser<C, World>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, World> worldParser() {
        return ParserDescriptor.of(new WorldParser<C>(), World.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, World> worldComponent() {
        return CommandComponent.builder().parser(WorldParser.worldParser());
    }

    @Override
    public @NonNull ArgumentParseResult<World> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        World world = Bukkit.getWorld((String)input);
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParseException(input, commandContext));
        }
        return ArgumentParseResult.success(world);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Bukkit.getWorlds().stream().map(World::getName).collect(Collectors.toList());
    }

    public static final class WorldParseException
    extends ParserException {
        private final String input;

        public WorldParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(WorldParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

