/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.geysermc.geyser.entity.type.living.animal.FrogEntity;
import org.geysermc.geyser.entity.type.living.animal.farm.TemperatureVariantAnimal;
import org.geysermc.geyser.entity.type.living.animal.tameable.CatEntity;
import org.geysermc.geyser.entity.type.living.animal.tameable.WolfEntity;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.item.GeyserInstrument;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.JukeboxSong;
import org.geysermc.geyser.level.PaintingType;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.ListRegistry;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;
import org.geysermc.geyser.session.cache.registry.RegistryUnit;
import org.geysermc.geyser.session.dialog.Dialog;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class JavaRegistries {
    private static final List<JavaRegistryKey<?>> VALUES = new ArrayList();
    public static final JavaRegistryKey<Block> BLOCK = JavaRegistries.createHardcoded("block", BlockRegistries.JAVA_BLOCKS, Block::javaId, Block::javaIdentifier, (Key key) -> ((List)BlockRegistries.JAVA_BLOCKS.get()).stream().filter(block -> block.javaIdentifier().equals(key)).findFirst());
    public static final JavaRegistryKey<Item> ITEM = JavaRegistries.createHardcoded("item", Registries.JAVA_ITEMS, Item::javaId, Item::javaKey, (Key key) -> Optional.ofNullable((Item)Registries.JAVA_ITEM_IDENTIFIERS.get(key.asString())));
    public static JavaRegistryKey<EntityType> ENTITY_TYPE = JavaRegistries.createHardcoded("entity_type", Arrays.asList(EntityType.values()), Enum::ordinal, (T type) -> MinecraftKey.key(type.name().toLowerCase(Locale.ROOT)), (Key key) -> {
        try {
            return Optional.of(EntityType.valueOf(key.value().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    });
    public static final JavaRegistryKey<ChatType> CHAT_TYPE = JavaRegistries.create("chat_type");
    public static final JavaRegistryKey<JavaDimension> DIMENSION_TYPE = JavaRegistries.create("dimension_type");
    public static final JavaRegistryKey<Integer> BIOME = JavaRegistries.create("worldgen/biome");
    public static final JavaRegistryKey<Enchantment> ENCHANTMENT = JavaRegistries.create("enchantment");
    public static final JavaRegistryKey<BannerPattern> BANNER_PATTERN = JavaRegistries.create("banner_pattern");
    public static final JavaRegistryKey<GeyserInstrument> INSTRUMENT = JavaRegistries.create("instrument");
    public static final JavaRegistryKey<JukeboxSong> JUKEBOX_SONG = JavaRegistries.create("jukebox_song");
    public static final JavaRegistryKey<PaintingType> PAINTING_VARIANT = JavaRegistries.create("painting_variant");
    public static final JavaRegistryKey<TrimMaterial> TRIM_MATERIAL = JavaRegistries.create("trim_material");
    public static final JavaRegistryKey<TrimPattern> TRIM_PATTERN = JavaRegistries.create("trim_pattern");
    public static final JavaRegistryKey<RegistryUnit> DAMAGE_TYPE = JavaRegistries.create("damage_type");
    public static final JavaRegistryKey<Dialog> DIALOG = JavaRegistries.create("dialog");
    public static final JavaRegistryKey<CatEntity.BuiltInVariant> CAT_VARIANT = JavaRegistries.create("cat_variant");
    public static final JavaRegistryKey<FrogEntity.BuiltInVariant> FROG_VARIANT = JavaRegistries.create("frog_variant");
    public static final JavaRegistryKey<WolfEntity.BuiltInVariant> WOLF_VARIANT = JavaRegistries.create("wolf_variant");
    public static final JavaRegistryKey<RegistryUnit> WOLF_SOUND_VARIANT = JavaRegistries.create("wolf_sound_variant");
    public static final JavaRegistryKey<TemperatureVariantAnimal.BuiltInVariant> PIG_VARIANT = JavaRegistries.create("pig_variant");
    public static final JavaRegistryKey<TemperatureVariantAnimal.BuiltInVariant> COW_VARIANT = JavaRegistries.create("cow_variant");
    public static final JavaRegistryKey<TemperatureVariantAnimal.BuiltInVariant> CHICKEN_VARIANT = JavaRegistries.create("chicken_variant");

    private static <T> JavaRegistryKey<T> create(String key, JavaRegistryKey.RegistryLookup<T> registryLookup) {
        JavaRegistryKey<T> registry = new JavaRegistryKey<T>(MinecraftKey.key(key), registryLookup);
        VALUES.add(registry);
        return registry;
    }

    private static <T> JavaRegistryKey<T> createHardcoded(String key, ListRegistry<T> registry, RegistryNetworkMapper<T> networkSerializer, RegistryObjectIdentifierMapper<T> objectIdentifierMapper, RegistryIdentifierObjectMapper<T> identifierObjectMapper) {
        return JavaRegistries.createHardcoded(key, (List)registry.get(), networkSerializer, objectIdentifierMapper, identifierObjectMapper);
    }

    private static <T> JavaRegistryKey<T> createHardcoded(String key, List<T> registry, RegistryNetworkMapper<T> networkSerializer, RegistryObjectIdentifierMapper<T> objectIdentifierMapper, RegistryIdentifierObjectMapper<T> identifierObjectMapper) {
        return JavaRegistries.create(key, new HardcodedLookup<T>(registry, networkSerializer, objectIdentifierMapper, identifierObjectMapper));
    }

    private static <T> JavaRegistryKey<T> create(String key) {
        return JavaRegistries.create(key, new RegistryCacheLookup());
    }

    public static @Nullable JavaRegistryKey<?> fromKey(Key registryKey) {
        for (JavaRegistryKey<?> registry : VALUES) {
            if (!registry.registryKey().equals(registryKey)) continue;
            return registry;
        }
        return null;
    }

    @FunctionalInterface
    static interface RegistryNetworkMapper<T> {
        public int get(T var1);
    }

    @FunctionalInterface
    static interface RegistryObjectIdentifierMapper<T> {
        public Key get(T var1);
    }

    @FunctionalInterface
    static interface RegistryIdentifierObjectMapper<T> {
        public Optional<T> get(Key var1);
    }

    private record HardcodedLookup<T>(List<T> registry, RegistryNetworkMapper<T> networkMapper, RegistryObjectIdentifierMapper<T> objectIdentifierMapper, RegistryIdentifierObjectMapper<T> identifierObjectMapper) implements JavaRegistryKey.RegistryLookup<T>
    {
        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, int networkId) {
            return Optional.ofNullable(this.registry.get(networkId)).map(value -> new RegistryEntryData<Object>(networkId, Objects.requireNonNull(this.objectIdentifierMapper.get(value)), value));
        }

        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, Key key) {
            Optional<Object> object = this.identifierObjectMapper.get(key);
            return object.map(value -> new RegistryEntryData<Object>(this.networkMapper.get(value), key, value));
        }

        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, T object) {
            int id = this.networkMapper.get(object);
            return Optional.ofNullable(this.registry.get(id)).map(value -> new RegistryEntryData<Object>(id, Objects.requireNonNull(this.objectIdentifierMapper.get(value)), value));
        }
    }

    private static class RegistryCacheLookup<T>
    implements JavaRegistryKey.RegistryLookup<T> {
        private RegistryCacheLookup() {
        }

        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, int networkId) {
            return Optional.ofNullable(this.registry(session, registryKey).entryById(networkId));
        }

        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, Key key) {
            return Optional.ofNullable(this.registry(session, registryKey).entryByKey(key));
        }

        @Override
        public Optional<RegistryEntryData<T>> entry(GeyserSession session, JavaRegistryKey<T> registryKey, T object) {
            return Optional.ofNullable(this.registry(session, registryKey).entryByValue(object));
        }

        private JavaRegistry<T> registry(GeyserSession session, JavaRegistryKey<T> key) {
            return session.getRegistryCache().registry(key);
        }
    }
}

