/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.Dialog;
import org.geysermc.geyser.session.dialog.DialogButton;
import org.geysermc.geyser.session.dialog.DialogHolder;
import org.geysermc.geyser.session.dialog.DialogWithButtons;
import org.geysermc.geyser.session.dialog.action.DialogAction;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.ServerLink;
import org.geysermc.mcprotocollib.protocol.data.game.ServerLinkType;

public class ServerLinksDialog
extends DialogWithButtons {
    public static final Key TYPE = MinecraftKey.key("server_links");

    protected ServerLinksDialog(GeyserSession session, NbtMap map, Dialog.IdGetter idGetter) {
        super(session, map, ServerLinksDialog.readDefaultExitAction(session, map, idGetter));
    }

    @Override
    protected List<DialogButton> buttons(DialogHolder holder) {
        return holder.session().getServerLinks().stream().map(link -> new DialogButton(ServerLinksDialog.linkDisplayName(holder, link), Optional.of(new DialogAction.OpenUrl(link.link())))).toList();
    }

    private static String linkDisplayName(DialogHolder holder, ServerLink link) {
        if (link.knownType() != null) {
            String linkName = link.knownType() == ServerLinkType.BUG_REPORT ? "report_bug" : link.knownType().name().toLowerCase(Locale.ROOT);
            return "known_server_link." + linkName;
        }
        return MessageTranslator.convertMessage(holder.session(), link.unknownType());
    }
}

