/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.RequestAbilityPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;

@Translator(packet=RequestAbilityPacket.class)
public class BedrockRequestAbilityTranslator
extends PacketTranslator<RequestAbilityPacket> {
    @Override
    public void translate(GeyserSession session, RequestAbilityPacket packet) {
        if (packet.getAbility() == Ability.FLYING) {
            boolean isFlying = packet.isBoolValue();
            if (!isFlying && session.getGameMode() == GameMode.SPECTATOR) {
                session.sendAdventureSettings();
                return;
            }
            if (isFlying && session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
                session.sendAdventureSettings();
                return;
            }
            session.setFlying(isFlying);
            ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(isFlying);
            session.sendDownstreamGamePacket((Packet)abilitiesPacket);
        }
    }
}

