/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import org.cloudburstmc.protocol.bedrock.data.inventory.InventoryTabLeft;
import org.cloudburstmc.protocol.bedrock.data.inventory.InventoryTabRight;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerInventoryOptionsPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.CraftingBookStateType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundRecipeBookChangeSettingsPacket;

@Translator(packet=SetPlayerInventoryOptionsPacket.class)
public class BedrockSetPlayerInventoryOptionsTranslator
extends PacketTranslator<SetPlayerInventoryOptionsPacket> {
    @Override
    public void translate(GeyserSession session, SetPlayerInventoryOptionsPacket packet) {
        if (session.getGameMode() == GameMode.CREATIVE && session.getPlayerInventory() == session.getOpenInventory()) {
            return;
        }
        boolean filtered = packet.isFiltering();
        boolean bookOpen = this.isBookOpen(packet.getLeftTab(), packet.getRightTab());
        session.sendDownstreamPacket((Packet)new ServerboundRecipeBookChangeSettingsPacket(CraftingBookStateType.CRAFTING, bookOpen, filtered));
    }

    private boolean isBookOpen(InventoryTabLeft leftTab, InventoryTabRight rightTab) {
        boolean leftOpen = leftTab != InventoryTabLeft.NONE && leftTab != InventoryTabLeft.SURVIVAL;
        boolean rightOpen = rightTab == InventoryTabRight.CRAFTING;
        return leftOpen || rightOpen;
    }
}

