/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import net.kyori.adventure.text.Component;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.OldSmithingTableTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundOpenScreenPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;

@Translator(packet=ClientboundOpenScreenPacket.class)
public class JavaOpenScreenTranslator
extends PacketTranslator<ClientboundOpenScreenPacket> {
    private static final Component SMITHING_TABLE_COMPONENT = Component.translatable((String)"container.upgrade");

    @Override
    public void translate(GeyserSession session, ClientboundOpenScreenPacket packet) {
        GeyserImpl.getInstance().getLogger().debug(session, packet.toString(), new Object[0]);
        if (packet.getContainerId() == 0) {
            return;
        }
        InventoryHolder<? extends Inventory> currentInventory = session.getInventoryHolder();
        OldSmithingTableTranslator newTranslator = session.isOldSmithingTable() && packet.getType() == ContainerType.ANVIL && packet.getTitle().equals(SMITHING_TABLE_COMPONENT) ? OldSmithingTableTranslator.INSTANCE : InventoryTranslator.inventoryTranslator(packet.getType());
        if (session.hasFormOpen()) {
            session.closeForm();
        }
        if (newTranslator == null) {
            if (currentInventory != null) {
                InventoryUtils.closeInventory(session, currentInventory, true);
            }
            ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(packet.getContainerId());
            session.sendDownstreamGamePacket((Packet)closeWindowPacket);
            return;
        }
        String name = MessageTranslator.convertMessage(packet.getTitle(), session.locale());
        Object newInventory = ((InventoryTranslator)newTranslator).createInventory(session, name, packet.getContainerId(), packet.getType());
        InventoryHolder newInventoryHolder = new InventoryHolder(session, (Inventory)newInventory, (InventoryTranslator<Inventory>)((InventoryTranslator<? extends Inventory>)newTranslator));
        if (currentInventory != null) {
            if (((InventoryTranslator)newTranslator).canReuseInventory(session, (Inventory)newInventory, currentInventory.inventory())) {
                newInventoryHolder.inheritFromExisting(currentInventory);
                GeyserImpl.getInstance().getLogger().debug(session, "Able to reuse current inventory. Is current pending? %s", currentInventory.pending());
                if (((Inventory)newInventory).isDisplayed()) {
                    newInventoryHolder.updateInventory();
                }
                return;
            }
            InventoryUtils.closeInventory(session, currentInventory, true);
        }
        InventoryUtils.openInventory(newInventoryHolder);
    }
}

