/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties.type;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.entity.properties.type.PropertyType;

public class EnumProperty
implements PropertyType {
    private final String name;
    private final List<String> values;
    private final Object2IntMap<String> valueIndexMap;

    public EnumProperty(String name, List<String> values) {
        this.name = name;
        this.values = values;
        this.valueIndexMap = new Object2IntOpenHashMap(values.size());
        for (int i = 0; i < values.size(); ++i) {
            this.valueIndexMap.put((Object)values.get(i), i);
        }
    }

    @Override
    public NbtMap nbtMap() {
        return NbtMap.builder().putString("name", this.name).putList("enum", NbtType.STRING, this.values).putInt("type", 3).build();
    }

    public int getIndex(String value) {
        return this.valueIndexMap.getOrDefault((Object)value, -1);
    }
}

