/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.vehicle.BoostableVehicleComponent;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class StriderEntity
extends AnimalEntity
implements Tickable,
ClientVehicle {
    private final BoostableVehicleComponent<StriderEntity> vehicleComponent = new BoostableVehicleComponent<StriderEntity>(this, 1.0f);
    private boolean isCold = false;

    public StriderEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
        this.setFlag(EntityFlag.BREATHING, true);
    }

    public void setCold(BooleanEntityMetadata entityMetadata) {
        this.isCold = entityMetadata.getPrimitiveValue();
    }

    public void setSaddled(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.SADDLED, entityMetadata.getPrimitiveValue());
    }

    @Override
    public void updateBedrockMetadata() {
        if (this.getFlag(EntityFlag.RIDING)) {
            boolean parentShaking = false;
            if (this.vehicle instanceof StriderEntity) {
                parentShaking = this.vehicle.getFlag(EntityFlag.SHAKING);
            }
            this.setFlag(EntityFlag.BREATHING, !parentShaking);
            this.setFlag(EntityFlag.SHAKING, parentShaking);
        } else {
            this.setFlag(EntityFlag.BREATHING, !this.isCold);
            this.setFlag(EntityFlag.SHAKING, this.isShaking());
        }
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            passenger.updateBedrockMetadata();
        }
        super.updateBedrockMetadata();
    }

    @Override
    protected boolean isShaking() {
        return this.isCold || super.isShaking();
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.STRIDER_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractiveTag.RIDE_STRIDER;
        }
        InteractiveTag tag = super.testMobInteraction(hand, itemInHand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand).consumesAction() ? InteractiveTag.SADDLE : InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand);
    }

    public void setBoost(IntEntityMetadata entityMetadata) {
        this.vehicleComponent.startBoost(entityMetadata.getPrimitiveValue());
    }

    @Override
    public void tick() {
        PlayerEntity player = this.getPlayerPassenger();
        if (player == null) {
            return;
        }
        if (player == this.session.getPlayerEntity()) {
            if (this.session.getPlayerInventory().isHolding(Items.WARPED_FUNGUS_ON_A_STICK)) {
                this.vehicleComponent.tickBoost();
            }
        } else {
            ItemDefinition itemDefinition = this.session.getItemMappings().getStoredItems().warpedFungusOnAStick().getBedrockDefinition();
            if (player.getHand().getDefinition() == itemDefinition || player.getOffhand().getDefinition() == itemDefinition) {
                this.vehicleComponent.tickBoost();
            }
        }
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public Vector2f getAdjustedInput(Vector2f input) {
        return Vector2f.UNIT_Y;
    }

    @Override
    public float getVehicleSpeed() {
        return this.vehicleComponent.getMoveSpeed() * (this.isCold ? 0.35f : 0.55f) * this.vehicleComponent.getBoostMultiplier();
    }

    private @Nullable PlayerEntity getPlayerPassenger() {
        Object e;
        if (this.getFlag(EntityFlag.SADDLED) && !this.passengers.isEmpty() && (e = this.passengers.get(0)) instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)e;
            return playerEntity;
        }
        return null;
    }

    @Override
    public boolean isClientControlled() {
        return this.getPlayerPassenger() == this.session.getPlayerEntity() && this.session.getPlayerInventory().isHolding(Items.WARPED_FUNGUS_ON_A_STICK);
    }

    @Override
    public boolean canWalkOnLava() {
        return true;
    }
}

