/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.mod.GeyserModConfiguration;
import org.geysermc.geyser.platform.mod.GeyserModInjector;
import org.geysermc.geyser.platform.mod.GeyserModLogger;
import org.geysermc.geyser.platform.mod.GeyserServerPortGetter;
import org.geysermc.geyser.platform.mod.ModPingPassthrough;
import org.geysermc.geyser.platform.mod.platform.GeyserModPlatform;
import org.geysermc.geyser.platform.mod.world.GeyserModWorldManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public abstract class GeyserModBootstrap
implements GeyserBootstrap {
    private static GeyserModBootstrap instance;
    private final GeyserModPlatform platform;
    private GeyserImpl geyser;
    private Path dataFolder;
    private MinecraftServer server;
    private CommandRegistry commandRegistry;
    private GeyserModConfiguration geyserConfig;
    private GeyserModInjector geyserInjector;
    private final GeyserModLogger geyserLogger = new GeyserModLogger();
    private IGeyserPingPassthrough geyserPingPassthrough;
    private WorldManager geyserWorldManager;

    @Override
    public void onGeyserInitialize() {
        instance = this;
        this.dataFolder = this.platform.dataFolder(this.platform.configPath());
        GeyserLocale.init(this);
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.geyser = GeyserImpl.load(this.platform.platformType(), this);
    }

    @Override
    public void onGeyserEnable() {
        if (this.geyser == null) {
            return;
        }
        if (GeyserImpl.getInstance().isReloading()) {
            if (!this.loadConfig()) {
                return;
            }
            this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
            GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        }
        GeyserImpl.start();
        this.geyserPingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : new ModPingPassthrough(this.server, this.geyserLogger);
        if (GeyserImpl.getInstance().isReloading()) {
            return;
        }
        this.geyserWorldManager = new GeyserModWorldManager(this.server);
        this.geyserInjector = new GeyserModInjector(this.server, this.platform);
        if (this.isServer()) {
            this.geyserInjector.initializeLocalChannel(this);
        }
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
            this.geyser = null;
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
            this.server = null;
        }
    }

    @Override
    public GeyserModConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Override
    public WorldManager getWorldManager() {
        return this.geyserWorldManager;
    }

    @Override
    public Path getConfigFolder() {
        return this.dataFolder;
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return this.platform.dumpInfo(this.server);
    }

    @Override
    public String getMinecraftServerVersion() {
        return this.server.getServerVersion();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        String ip = this.server.getLocalIp();
        return ip != null ? ip : "";
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    @Override
    public int getServerPort() {
        if (this.isServer()) {
            return ((GeyserServerPortGetter)this.server).geyser$getServerPort();
        }
        return this.geyserConfig.getRemote().port();
    }

    public abstract boolean isServer();

    @Override
    public boolean testFloodgatePluginPresent() {
        return this.platform.testFloodgatePluginPresent(this);
    }

    @Override
    public @Nullable InputStream getResourceOrNull(String resource) {
        return this.platform.resolveResource(resource);
    }

    private boolean loadConfig() {
        try {
            if (!this.dataFolder.toFile().exists()) {
                this.dataFolder.toFile().mkdir();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(this.dataFolder.resolve("config.yml").toFile(), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserModConfiguration.class);
            return true;
        }
        catch (IOException ex) {
            this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            return false;
        }
    }

    public GeyserModBootstrap(GeyserModPlatform platform) {
        this.platform = platform;
    }

    public static GeyserModBootstrap getInstance() {
        return instance;
    }

    public GeyserImpl getGeyser() {
        return this.geyser;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void setCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }
}

