/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard.display.slot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.scoreboard.display.score.SidebarDisplayScore;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.geysermc.geyser.text.ChatColor;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;

public final class SidebarDisplaySlot
extends DisplaySlot {
    private static final int SCORE_DISPLAY_LIMIT = 15;
    private static final Comparator<ScoreReference> SCORE_DISPLAY_ORDER = Comparator.comparing(ScoreReference::score).reversed().thenComparing(ScoreReference::name, String.CASE_INSENSITIVE_ORDER);
    private List<SidebarDisplayScore> displayScores = new ArrayList<SidebarDisplayScore>(15);

    public SidebarDisplaySlot(GeyserSession session, Objective objective, ScoreboardPosition position) {
        super(session, objective, position);
    }

    @Override
    protected void render0(List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        List newDisplayScores = this.objective.getScores().values().stream().filter(score -> !score.hidden()).sorted(SCORE_DISPLAY_ORDER).limit(15L).map(reference -> {
            Iterator<SidebarDisplayScore> iterator = this.displayScores.iterator();
            while (iterator.hasNext()) {
                SidebarDisplayScore score = iterator.next();
                if (!score.name().equals(reference.name())) continue;
                iterator.remove();
                return score;
            }
            return new SidebarDisplayScore(this, this.objective.getScoreboard().nextId(), (ScoreReference)reference);
        }).collect(Collectors.toList());
        for (SidebarDisplayScore score2 : this.displayScores) {
            removeScores.add(score2.cachedInfo());
        }
        this.displayScores = newDisplayScores;
        if (!this.displayScores.isEmpty()) {
            SidebarDisplayScore lastScore = null;
            int count = 0;
            for (SidebarDisplayScore score3 : this.displayScores) {
                if (lastScore == null) {
                    lastScore = score3;
                    continue;
                }
                if (score3.score() == lastScore.score()) {
                    if (count == 0) {
                        lastScore.order(ChatColor.styleOrder(count++));
                    }
                    score3.order(ChatColor.styleOrder(count++));
                } else {
                    if (count == 0) {
                        lastScore.order(null);
                    }
                    count = 0;
                }
                lastScore = score3;
            }
            if (count == 0 && lastScore != null) {
                lastScore.order(null);
            }
        }
        boolean objectiveAdd = this.updateType == UpdateType.ADD;
        boolean objectiveUpdate = this.updateType == UpdateType.UPDATE;
        for (SidebarDisplayScore score3 : this.displayScores) {
            Team team = score3.team();
            boolean add = objectiveAdd || objectiveUpdate;
            boolean exists = score3.exists();
            if (team != null && (team.shouldRemove() || !team.hasEntity(score3.name()))) {
                score3.team(null);
                add = true;
            }
            if (score3.shouldUpdate()) {
                score3.update(this.objective);
                add = true;
            }
            if (add) {
                addScores.add(score3.cachedInfo());
            }
            if (!add || !exists || objectiveUpdate || objectiveAdd || score3.onlyScoreValueChanged()) continue;
            removeScores.add(score3.cachedInfo());
        }
        if (objectiveUpdate) {
            this.sendRemoveObjective();
        }
        if (objectiveAdd || objectiveUpdate) {
            this.sendDisplayObjective();
        }
        this.updateType = UpdateType.NOTHING;
    }

    @Override
    public void addScore(ScoreReference reference) {
    }

    @Override
    public void playerRegistered(PlayerEntity player) {
    }

    @Override
    public void playerRemoved(PlayerEntity player) {
    }

    public void setTeamFor(Team team, Set<String> entities) {
        for (SidebarDisplayScore score : this.displayScores) {
            if (!entities.contains(score.name())) continue;
            score.team(team);
        }
    }
}

