/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.util.HashMap;
import java.util.Map;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.util.TriState;

public final class Permissions {
    private static final Map<String, TriState> PERMISSIONS = new HashMap<String, TriState>();
    public static final String CHECK_UPDATE = Permissions.register("geyser.update");
    public static final String SERVER_SETTINGS = Permissions.register("geyser.settings.server");
    public static final String SETTINGS_GAMERULES = Permissions.register("geyser.settings.gamerules");

    private Permissions() {
    }

    private static String register(String permission) {
        return Permissions.register(permission, TriState.NOT_SET);
    }

    private static String register(String permission, TriState permissionDefault) {
        PERMISSIONS.put(permission, permissionDefault);
        return permission;
    }

    public static void register(GeyserRegisterPermissionsEvent event) {
        for (Map.Entry<String, TriState> permission : PERMISSIONS.entrySet()) {
            event.register(permission.getKey(), permission.getValue());
        }
    }
}

