/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.configuration.ConfigMigrations;
import org.geysermc.geyser.configuration.ConfigurationCommentMover;
import org.geysermc.geyser.configuration.ExcludePlatform;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.configuration.LowercaseEnumSerializer;
import org.geysermc.geyser.configuration.PluginSpecific;
import org.geysermc.geyser.text.GeyserLocale;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.interfaces.InterfaceDefaultOptions;
import org.spongepowered.configurate.objectmapping.meta.Processor;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class ConfigLoader {
    private static final String HEADER = "--------------------------------\nGeyser Configuration File\n\nA bridge between Minecraft: Bedrock Edition and Minecraft: Java Edition.\n\nGitHub: https://github.com/GeyserMC/Geyser\nDiscord: https://discord.gg/geysermc\nWiki: https://geysermc.org/wiki\n\nNOTICE: See https://geysermc.org/wiki/geyser/setup/ for the setup guide. Many video tutorials are outdated.\nIn most cases, especially with server hosting providers, further hosting-specific configuration is required.\n--------------------------------";
    private final @Nullable GeyserBootstrap bootstrap;
    private PlatformType platformType;
    private @Nullable Consumer<CommentedConfigurationNode> transformer;
    private File configFile;
    @VisibleForTesting
    CommentedConfigurationNode configurationNode;

    public ConfigLoader(GeyserBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.platformType = bootstrap.platformType();
        this.configFile = new File(bootstrap.getConfigFolder().toFile(), "config.yml");
    }

    @VisibleForTesting
    ConfigLoader(File file) {
        this.bootstrap = null;
        this.configFile = file;
    }

    public @This ConfigLoader createFolder() {
        Path dataFolder = this.bootstrap.getConfigFolder();
        if (!dataFolder.toFile().exists() && !dataFolder.toFile().mkdir()) {
            GeyserImpl.getInstance().getLogger().warning("Failed to create config folder: " + String.valueOf(dataFolder));
        }
        return this;
    }

    public @This ConfigLoader transformer(Consumer<CommentedConfigurationNode> transformer) {
        this.transformer = transformer;
        return this;
    }

    public @This ConfigLoader configFile(File configFile) {
        this.configFile = configFile;
        return this;
    }

    public <T extends GeyserConfig> @Nullable T load(Class<T> configClass) {
        try {
            return this.load0(configClass);
        }
        catch (IOException ex) {
            this.bootstrap.getGeyserLogger().error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            return null;
        }
    }

    private <T extends GeyserConfig> T load0(Class<T> configClass) throws ConfigurateException {
        YamlConfigurationLoader loader = this.createLoader(this.configFile);
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        boolean originallyEmpty = !this.configFile.exists() || node.isNull();
        ConfigurationTransformation.Versioned migrations = ConfigMigrations.TRANSFORMER.apply(configClass, this.bootstrap);
        int currentVersion = migrations.version((ConfigurationNode)node);
        migrations.apply((ConfigurationNode)node);
        int newVersion = migrations.version((ConfigurationNode)node);
        GeyserConfig config = (GeyserConfig)node.get(configClass);
        CommentedConfigurationNode newRoot = CommentedConfigurationNode.root((ConfigurationOptions)loader.defaultOptions());
        newRoot.set((Object)config);
        if (originallyEmpty || currentVersion != newVersion) {
            if (!originallyEmpty && currentVersion > 4) {
                ConfigurationCommentMover.moveComments(node, newRoot);
            }
            loader.save((ConfigurationNode)newRoot);
        }
        if (this.transformer != null) {
            this.transformer.accept(newRoot);
            config = (GeyserConfig)newRoot.get(configClass);
        }
        if (this.bootstrap != null) {
            this.bootstrap.getGeyserLogger().setDebug(config.debugMode());
        } else {
            this.configurationNode = newRoot;
        }
        return (T)config;
    }

    @VisibleForTesting
    CommentedConfigurationNode loadConfigurationNode(Class<? extends GeyserConfig> configClass, PlatformType platformType) throws ConfigurateException {
        this.platformType = platformType;
        this.load0(configClass);
        return (CommentedConfigurationNode)this.configurationNode.copy();
    }

    private YamlConfigurationLoader createLoader(File file) {
        return ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).indent(2).nodeStyle(NodeStyle.BLOCK).defaultOptions(options -> InterfaceDefaultOptions.addTo((ConfigurationOptions)options, builder -> builder.addProcessor(ExcludePlatform.class, ConfigLoader.excludePlatform(this.platformType.platformName())).addProcessor(PluginSpecific.class, ConfigLoader.integrationSpecific(this.platformType != PlatformType.STANDALONE))).shouldCopyDefaults(false).header(HEADER).serializers(builder -> builder.register((ScalarSerializer)new LowercaseEnumSerializer())))).build();
    }

    private static Processor.Factory<ExcludePlatform, Object> excludePlatform(String thisPlatform) {
        return (data, fieldType) -> (value, destination) -> {
            for (String platform : data.platforms()) {
                if (!thisPlatform.equals(platform)) continue;
                destination.parent().removeChild(destination.key());
                break;
            }
        };
    }

    private static Processor.Factory<PluginSpecific, Object> integrationSpecific(boolean thisConfigPlugin) {
        return (data, fieldType) -> (value, destination) -> {
            if (data.forPlugin() != thisConfigPlugin) {
                destination.parent().removeChild(destination.key());
            }
        };
    }
}

