/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.SnifferState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;

public class SnifferEntity
extends AnimalEntity
implements Tickable {
    private static final float DIGGING_HEIGHT = EntityDefinitions.SNIFFER.height() - 0.4f;
    private static final int DIG_END = 120;
    private static final int DIG_START = 86;
    private Pose pose = Pose.STANDING;
    private int digTicks;

    public SnifferEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setPose(Pose pose) {
        this.pose = pose;
        super.setPose(pose);
    }

    @Override
    protected void setDimensionsFromPose(Pose pose) {
        if (this.getFlag(EntityFlag.DIGGING)) {
            this.setBoundingBoxHeight(DIGGING_HEIGHT);
            this.setBoundingBoxWidth(this.definition.width());
        } else {
            super.setDimensionsFromPose(pose);
        }
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.SNIFFER_FOOD;
    }

    public void setSnifferState(ObjectEntityMetadata<SnifferState> entityMetadata) {
        SnifferState snifferState = entityMetadata.getValue();
        this.setFlag(EntityFlag.FEELING_HAPPY, snifferState == SnifferState.FEELING_HAPPY);
        this.setFlag(EntityFlag.SCENTING, snifferState == SnifferState.SNIFFING);
        this.setFlag(EntityFlag.SEARCHING, snifferState == SnifferState.SEARCHING);
        this.setFlag(EntityFlag.DIGGING, snifferState == SnifferState.DIGGING);
        this.setFlag(EntityFlag.RISING, snifferState == SnifferState.RISING);
        this.setDimensionsFromPose(this.pose);
        this.digTicks = this.getFlag(EntityFlag.DIGGING) ? 120 : 0;
    }

    @Override
    public void tick() {
        if (this.digTicks > 0 && --this.digTicks < 86 && this.digTicks % 5 == 0) {
            Vector3f rot = Vector3f.createDirectionDeg((float)0.0f, (float)(-this.getYaw())).mul(2.25f);
            Vector3f pos = this.getPosition().add(rot).up(0.2f).floor();
            int blockId = this.session.getBlockMappings().getBedrockBlockId(this.session.getGeyser().getWorldManager().getBlockAt(this.session, pos.toInt().down()));
            LevelEventPacket levelEventPacket = new LevelEventPacket();
            levelEventPacket.setType(LevelEvent.PARTICLE_DESTROY_BLOCK_NO_SOUND);
            levelEventPacket.setPosition(pos);
            levelEventPacket.setData(blockId);
            this.session.sendUpstreamPacket(levelEventPacket);
            if (this.digTicks % 10 == 0) {
                LevelSoundEventPacket levelSoundEventPacket = new LevelSoundEventPacket();
                levelSoundEventPacket.setSound(SoundEvent.HIT);
                levelSoundEventPacket.setPosition(pos);
                levelSoundEventPacket.setExtraData(blockId);
                levelSoundEventPacket.setIdentifier(":");
                this.session.sendUpstreamPacket(levelSoundEventPacket);
            }
        }
    }
}

