/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJweHeaderBuilder;
import io.jsonwebtoken.impl.DefaultJweHeaderMutator;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.lang.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultJwtHeaderBuilder
extends DefaultJweHeaderBuilder<Jwts.HeaderBuilder>
implements Jwts.HeaderBuilder {
    public DefaultJwtHeaderBuilder() {
    }

    public DefaultJwtHeaderBuilder(DefaultJweHeaderMutator<?> src) {
        super(src);
    }

    private static ParameterMap sanitizeCrit(ParameterMap m4, boolean protectedHeader) {
        Set<String> crit = m4.get(DefaultProtectedHeader.CRIT);
        if (crit == null) {
            return m4;
        }
        m4 = new ParameterMap(DefaultJweHeader.PARAMS, m4, true);
        m4.remove(DefaultProtectedHeader.CRIT.getId());
        if (!protectedHeader) {
            return m4;
        }
        LinkedHashSet<String> newCrit = new LinkedHashSet<String>(crit);
        for (String val : crit) {
            if (!DefaultJweHeader.PARAMS.containsKey(val) && m4.containsKey(val)) continue;
            newCrit.remove(val);
        }
        if (!Collections.isEmpty(newCrit)) {
            m4.put(DefaultProtectedHeader.CRIT, (Object)newCrit);
        }
        return m4;
    }

    @Override
    public Header build() {
        this.x509.apply();
        ParameterMap m4 = (ParameterMap)this.DELEGATE;
        if (DefaultJweHeader.isCandidate(m4)) {
            return new DefaultJweHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m4, true));
        }
        if (DefaultProtectedHeader.isCandidate(m4)) {
            return new DefaultJwsHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m4, true));
        }
        return new DefaultHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m4, false));
    }
}

