/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BedBlock;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.TrapDoorBlock;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.CollisionManager;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.SolidCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;

public class VehicleComponent<T extends LivingEntity> {
    private static final ObjectDoublePair<Fluid> EMPTY_FLUID_PAIR = ObjectDoublePair.of(Fluid.EMPTY, 0.0);
    private static final float MAX_LOGICAL_FLUID_HEIGHT = 0.8888889f;
    private static final float BASE_SLIPPERINESS_CUBED = 0.21600002f;
    private static final float MIN_VELOCITY = 0.003f;
    protected final T vehicle;
    protected final BoundingBox boundingBox;
    protected float stepHeight;
    protected float moveSpeed;
    protected double gravity;
    protected double waterMovementEfficiency;
    protected int effectLevitation;
    protected boolean effectSlowFalling;
    protected boolean effectWeaving;

    public VehicleComponent(T vehicle, float stepHeight) {
        this.vehicle = vehicle;
        this.stepHeight = stepHeight;
        this.moveSpeed = (float)AttributeType.Builtin.MOVEMENT_SPEED.getDef();
        this.gravity = AttributeType.Builtin.GRAVITY.getDef();
        this.waterMovementEfficiency = AttributeType.Builtin.WATER_MOVEMENT_EFFICIENCY.getDef();
        double width = ((Entity)vehicle).getBoundingBoxWidth();
        double height = ((Entity)vehicle).getBoundingBoxHeight();
        this.boundingBox = new BoundingBox(((Entity)vehicle).getPosition().getX(), (double)((Entity)vehicle).getPosition().getY() + height / 2.0, ((Entity)vehicle).getPosition().getZ(), width, height, width);
    }

    public void setWidth(float width) {
        this.boundingBox.setSizeX(width);
        this.boundingBox.setSizeZ(width);
    }

    public void setHeight(float height) {
        this.boundingBox.translate(0.0, ((double)height - this.boundingBox.getSizeY()) / 2.0, 0.0);
        this.boundingBox.setSizeY(height);
    }

    public void moveAbsolute(double x, double y, double z) {
        this.boundingBox.setMiddleX(x);
        this.boundingBox.setMiddleY(y + this.boundingBox.getSizeY() / 2.0);
        this.boundingBox.setMiddleZ(z);
    }

    public void moveAbsolute(Vector3d vec) {
        this.moveAbsolute(vec.getX(), vec.getY(), vec.getZ());
    }

    public void moveRelative(double x, double y, double z) {
        this.boundingBox.translate(x, y, z);
    }

    public void moveRelative(Vector3d vec) {
        this.boundingBox.translate(vec);
    }

    public void setEffect(Effect effect, int effectAmplifier) {
        switch (effect) {
            case LEVITATION: {
                this.effectLevitation = effectAmplifier + 1;
                break;
            }
            case SLOW_FALLING: {
                this.effectSlowFalling = true;
                break;
            }
            case WEAVING: {
                this.effectWeaving = true;
            }
        }
    }

    public void removeEffect(Effect effect) {
        switch (effect) {
            case LEVITATION: {
                this.effectLevitation = 0;
                break;
            }
            case SLOW_FALLING: {
                this.effectSlowFalling = false;
                break;
            }
            case WEAVING: {
                this.effectWeaving = false;
            }
        }
    }

    public void setStepHeight(float stepHeight) {
        this.stepHeight = MathUtils.clamp(stepHeight, 1.0f, 10.0f);
    }

    public void setGravity(double gravity) {
        this.gravity = MathUtils.constrain(gravity, -1.0, 1.0);
    }

    public Vector3d correctMovement(Vector3d movement) {
        return ((Entity)this.vehicle).getSession().getCollisionManager().correctMovement(movement, this.boundingBox, ((Entity)this.vehicle).isOnGround(), this.stepHeight, true, ((ClientVehicle)this.vehicle).canWalkOnLava());
    }

    public void onMount() {
        ((Entity)this.vehicle).getSession().getPlayerEntity().setVehicleInput(Vector2f.ZERO);
        ((Entity)this.vehicle).getSession().getPlayerEntity().setVehicleJumpStrength(0);
    }

    public void onDismount() {
    }

    public void tickVehicle() {
        if (!((ClientVehicle)this.vehicle).isClientControlled()) {
            return;
        }
        VehicleContext ctx = new VehicleContext();
        ctx.loadSurroundingBlocks();
        ObjectDoublePair<Fluid> fluidHeight = this.updateFluidMovement(ctx);
        switch ((Fluid)((Object)fluidHeight.left())) {
            case WATER: {
                this.waterMovement(ctx);
                break;
            }
            case LAVA: {
                if (((ClientVehicle)this.vehicle).canWalkOnLava() && ctx.centerBlock().is(Blocks.LAVA)) {
                    this.landMovement(ctx);
                    break;
                }
                this.lavaMovement(ctx, fluidHeight.rightDouble());
                break;
            }
            case EMPTY: {
                this.landMovement(ctx);
            }
        }
    }

    protected void updateRotation() {
        Vector2f rot = this.getRiddenRotation();
        ((Entity)this.vehicle).setYaw(rot.getX());
        ((Entity)this.vehicle).setHeadYaw(rot.getX());
        ((Entity)this.vehicle).setPitch(rot.getY());
    }

    protected ObjectDoublePair<Fluid> updateFluidMovement(VehicleContext ctx) {
        BoundingBox box = this.boundingBox.clone();
        box.expand(-0.001);
        Vector3d min2 = box.getMin();
        Vector3d max = box.getMax();
        BlockPositionIterator iter = BlockPositionIterator.fromMinMax(min2.getFloorX(), min2.getFloorY(), min2.getFloorZ(), max.getFloorX(), max.getFloorY(), max.getFloorZ());
        double waterHeight = this.getFluidHeightAndApplyMovement(ctx, iter, Fluid.WATER, 0.014, min2.getY());
        double lavaHeight = this.getFluidHeightAndApplyMovement(ctx, iter, Fluid.LAVA, ((Entity)this.vehicle).getSession().getDimensionType().ultrawarm() ? 0.007 : 0.0023333333333333335, min2.getY());
        if (lavaHeight > 0.0 && ((Entity)this.vehicle).getDefinition().entityType() == EntityType.STRIDER) {
            Vector3i blockPos = ctx.centerPos().toInt();
            if (!CollisionManager.FLUID_COLLISION.isBelow(blockPos.getY(), this.boundingBox) || ctx.getBlock(blockPos.up()).is(Blocks.LAVA)) {
                ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(0.5f).add(0.0f, 0.05f, 0.0f));
            } else {
                ((Entity)this.vehicle).setOnGround(true);
            }
        }
        if (waterHeight > 0.0) {
            return ObjectDoublePair.of(Fluid.WATER, waterHeight);
        }
        if (lavaHeight > 0.0) {
            return ObjectDoublePair.of(Fluid.LAVA, lavaHeight);
        }
        return EMPTY_FLUID_PAIR;
    }

    protected double getFluidHeightAndApplyMovement(VehicleContext ctx, BlockPositionIterator iter, Fluid fluid, double speed, double minY) {
        Vector3d totalVelocity = Vector3d.ZERO;
        double maxFluidHeight = 0.0;
        int fluidBlocks = 0;
        iter.reset();
        while (iter.hasNext()) {
            int blockId = ctx.getBlockId(iter);
            if (BlockStateValues.getFluid(blockId) == fluid) {
                Vector3i blockPos = Vector3i.from(iter.getX(), iter.getY(), iter.getZ());
                float worldFluidHeight = this.getWorldFluidHeight(fluid, blockId);
                double vehicleFluidHeight = (double)((float)blockPos.getY() + worldFluidHeight) - minY;
                if (!(vehicleFluidHeight < 0.0)) {
                    boolean flowBlocked = worldFluidHeight != 1.0f;
                    Vector3d velocity = Vector3d.ZERO;
                    for (Direction direction : Direction.HORIZONTAL) {
                        Vector3i adjacentBlockPos = blockPos.add(direction.getUnitVector());
                        int adjacentBlockId = ctx.getBlockId(adjacentBlockPos);
                        Fluid adjacentFluid = BlockStateValues.getFluid(adjacentBlockId);
                        float fluidHeightDiff = 0.0f;
                        if (adjacentFluid == fluid) {
                            fluidHeightDiff = this.getLogicalFluidHeight(fluid, blockId) - this.getLogicalFluidHeight(fluid, adjacentBlockId);
                        } else if (adjacentFluid == Fluid.EMPTY) {
                            BlockCollision adjacentBlockCollision = BlockUtils.getCollision(adjacentBlockId);
                            if (adjacentBlockCollision == null) {
                                float adjacentFluidHeight = this.getLogicalFluidHeight(fluid, ctx.getBlockId(adjacentBlockPos.add(Direction.DOWN.getUnitVector())));
                                if (adjacentFluidHeight != -1.0f) {
                                    fluidHeightDiff = this.getLogicalFluidHeight(fluid, blockId) - (adjacentFluidHeight - 0.8888889f);
                                }
                            } else if (!flowBlocked) {
                                flowBlocked = this.isFlowBlocked(fluid, adjacentBlockId);
                            }
                        }
                        if (fluidHeightDiff == 0.0f) continue;
                        velocity = velocity.add(direction.getUnitVector().toDouble().mul(fluidHeightDiff));
                    }
                    if (worldFluidHeight == 1.0f) {
                        if (!flowBlocked) {
                            Direction direction;
                            Vector3i blockPosUp = blockPos.up();
                            Direction[] directionArray = Direction.HORIZONTAL;
                            int n = directionArray.length;
                            for (int i = 0; i < n && !(flowBlocked = this.isFlowBlocked(fluid, ctx.getBlockId(blockPosUp.add((direction = directionArray[i]).getUnitVector())))); ++i) {
                            }
                        }
                        if (flowBlocked) {
                            velocity = this.javaNormalize(velocity).add(0.0, -6.0, 0.0);
                        }
                    }
                    velocity = this.javaNormalize(velocity);
                    if ((maxFluidHeight = Math.max(vehicleFluidHeight, maxFluidHeight)) < 0.4) {
                        velocity = velocity.mul(maxFluidHeight);
                    }
                    totalVelocity = totalVelocity.add(velocity);
                    ++fluidBlocks;
                }
            }
            iter.next();
        }
        if (!totalVelocity.equals(Vector3d.ZERO)) {
            Vector3f motion = ((Entity)this.vehicle).getMotion();
            totalVelocity = this.javaNormalize(totalVelocity.mul(1.0 / (double)fluidBlocks));
            if ((totalVelocity = totalVelocity.mul(speed)).length() < 0.0045 && Math.abs(motion.getX()) < 0.003f && Math.abs(motion.getZ()) < 0.003f) {
                totalVelocity = this.javaNormalize(totalVelocity).mul(0.0045);
            }
            ((Entity)this.vehicle).setMotion(motion.add(totalVelocity.toFloat()));
        }
        return maxFluidHeight;
    }

    protected Vector3d javaNormalize(Vector3d vec) {
        double len = vec.length();
        return len < (double)1.0E-5f ? Vector3d.ZERO : Vector3d.from(vec.getX() / len, vec.getY() / len, vec.getZ() / len);
    }

    protected float getWorldFluidHeight(Fluid fluidType, int blockId) {
        return switch (fluidType) {
            default -> throw new IncompatibleClassChangeError();
            case Fluid.WATER -> (float)BlockStateValues.getWaterHeight(blockId);
            case Fluid.LAVA -> (float)BlockStateValues.getLavaHeight(blockId);
            case Fluid.EMPTY -> -1.0f;
        };
    }

    protected float getLogicalFluidHeight(Fluid fluidType, int blockId) {
        return Math.min(this.getWorldFluidHeight(fluidType, blockId), 0.8888889f);
    }

    protected boolean isFlowBlocked(Fluid fluid, int adjacentBlockId) {
        if (BlockState.of(adjacentBlockId).is(Blocks.ICE)) {
            return false;
        }
        if (BlockStateValues.getFluid(adjacentBlockId) == fluid) {
            return false;
        }
        return BlockUtils.getCollision(adjacentBlockId) instanceof SolidCollision;
    }

    protected void waterMovement(VehicleContext ctx) {
        double gravity = this.getGravity();
        float drag = ((Entity)this.vehicle).getFlag(EntityFlag.SPRINTING) ? 0.9f : 0.8f;
        double originalY = ctx.centerPos().getY();
        boolean falling = ((Entity)this.vehicle).getMotion().getY() <= 0.0f;
        boolean horizontalCollision = this.travel(ctx, 0.02f);
        if (horizontalCollision && this.isClimbing(ctx)) {
            ((Entity)this.vehicle).setMotion(Vector3f.from(((Entity)this.vehicle).getMotion().getX(), 0.2f, ((Entity)this.vehicle).getMotion().getZ()));
        }
        ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(drag, 0.8f, drag));
        ((Entity)this.vehicle).setMotion(this.getFluidGravity(gravity, falling));
        if (horizontalCollision && this.shouldApplyFluidJumpBoost(ctx, originalY)) {
            ((Entity)this.vehicle).setMotion(Vector3f.from(((Entity)this.vehicle).getMotion().getX(), 0.3f, ((Entity)this.vehicle).getMotion().getZ()));
        }
    }

    protected void lavaMovement(VehicleContext ctx, double lavaHeight) {
        double gravity = this.getGravity();
        double originalY = ctx.centerPos().getY();
        boolean falling = ((Entity)this.vehicle).getMotion().getY() <= 0.0f;
        boolean horizontalCollision = this.travel(ctx, 0.02f);
        double d = this.boundingBox.getSizeY() * 0.85 < 0.4 ? 0.0 : 0.4;
        if (lavaHeight <= d) {
            ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(0.5f, 0.8f, 0.5f));
            ((Entity)this.vehicle).setMotion(this.getFluidGravity(gravity, falling));
        } else {
            ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(0.5f));
        }
        ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().down((float)(gravity / 4.0)));
        if (horizontalCollision && this.shouldApplyFluidJumpBoost(ctx, originalY)) {
            ((Entity)this.vehicle).setMotion(Vector3f.from(((Entity)this.vehicle).getMotion().getX(), 0.3f, ((Entity)this.vehicle).getMotion().getZ()));
        }
    }

    protected void landMovement(VehicleContext ctx) {
        double gravity = this.getGravity();
        float slipperiness = BlockStateValues.getSlipperiness(this.getVelocityBlock(ctx));
        float drag = ((Entity)this.vehicle).isOnGround() ? 0.91f * slipperiness : 0.91f;
        float speed = ((ClientVehicle)this.vehicle).getVehicleSpeed() * (((Entity)this.vehicle).isOnGround() ? 0.21600002f / (slipperiness * slipperiness * slipperiness) : 0.1f);
        boolean horizontalCollision = this.travel(ctx, speed);
        if (this.isClimbing(ctx)) {
            Vector3f motion = ((Entity)this.vehicle).getMotion();
            ((Entity)this.vehicle).setMotion(Vector3f.from(MathUtils.clamp(motion.getX(), -0.15f, 0.15f), horizontalCollision ? 0.2f : Math.max(motion.getY(), -0.15f), MathUtils.clamp(motion.getZ(), -0.15f, 0.15f)));
        }
        if (this.effectLevitation > 0) {
            ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().up((0.05f * (float)this.effectLevitation - ((Entity)this.vehicle).getMotion().getY()) * 0.2f));
        } else {
            ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().down((float)gravity));
        }
        ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(drag, 0.98f, drag));
    }

    protected boolean shouldApplyFluidJumpBoost(VehicleContext ctx, double originalY) {
        BoundingBox box = this.boundingBox.clone();
        box.translate(((Entity)this.vehicle).getMotion().toDouble().up((double)0.6f - ctx.centerPos().getY() + originalY));
        box.expand(-1.0E-7);
        BlockPositionIterator iter = ((Entity)this.vehicle).getSession().getCollisionManager().collidableBlocksIterator(box);
        iter.reset();
        while (iter.hasNext()) {
            int blockId = ctx.getBlockId(iter);
            BlockCollision blockCollision = BlockUtils.getCollision(blockId);
            if (blockCollision == null && BlockStateValues.getFluid(blockId) != Fluid.EMPTY) {
                blockCollision = CollisionManager.SOLID_COLLISION;
            }
            if (blockCollision != null && blockCollision.checkIntersection(iter.getX(), iter.getY(), iter.getZ(), box)) {
                return false;
            }
            iter.next();
        }
        return true;
    }

    protected Vector3f getFluidGravity(double gravity, boolean falling) {
        Vector3f motion = ((Entity)this.vehicle).getMotion();
        if (gravity != 0.0 && !((Entity)this.vehicle).getFlag(EntityFlag.SPRINTING)) {
            float newY = (float)((double)motion.getY() - gravity / 16.0);
            if (falling && Math.abs(motion.getY() - 0.005f) >= 0.003f && Math.abs(newY) < 0.003f) {
                newY = -0.003f;
            }
            return Vector3f.from(motion.getX(), newY, motion.getZ());
        }
        return motion;
    }

    protected @Nullable Vector3f getBlockMovementMultiplier(VehicleContext ctx) {
        BoundingBox box = this.boundingBox.clone();
        box.expand(-1.0E-7);
        Vector3i min2 = box.getMin().toInt();
        Vector3i max = box.getMax().toInt();
        for (int x = max.getX(); x >= min2.getX(); --x) {
            for (int y = max.getY(); y >= min2.getY(); --y) {
                for (int z = max.getZ(); z >= min2.getZ(); --z) {
                    Block block = ctx.getBlock(x, y, z).block();
                    Vector3f multiplier = null;
                    if (block == Blocks.COBWEB) {
                        multiplier = this.effectWeaving ? Vector3f.from(0.5, 0.25, 0.5) : Vector3f.from(0.25, (double)0.05f, 0.25);
                    } else if (block == Blocks.POWDER_SNOW) {
                        multiplier = Vector3f.from((double)0.9f, 1.5, (double)0.9f);
                    } else if (block == Blocks.SWEET_BERRY_BUSH) {
                        multiplier = Vector3f.from((double)0.8f, 0.75, (double)0.8f);
                    }
                    if (multiplier == null) continue;
                    return multiplier;
                }
            }
        }
        return null;
    }

    protected void applyBlockCollisionEffects(VehicleContext ctx) {
        BoundingBox box = this.boundingBox.clone();
        box.expand(-1.0E-7);
        Vector3i min2 = box.getMin().toInt();
        Vector3i max = box.getMax().toInt();
        BlockPositionIterator iter = BlockPositionIterator.fromMinMax(min2.getX(), min2.getY(), min2.getZ(), max.getX(), max.getY(), max.getZ());
        iter.reset();
        while (iter.hasNext()) {
            BlockState blockState = ctx.getBlock(iter);
            if (blockState.is(Blocks.HONEY_BLOCK)) {
                this.onHoneyBlockCollision();
            } else if (blockState.is(Blocks.BUBBLE_COLUMN)) {
                this.onBubbleColumnCollision(blockState.getValue(Properties.DRAG));
            }
            iter.next();
        }
    }

    protected void onHoneyBlockCollision() {
        if (((Entity)this.vehicle).isOnGround() || ((Entity)this.vehicle).getMotion().getY() >= -0.08f) {
            return;
        }
        Vector3f motion = ((Entity)this.vehicle).getMotion();
        float mul = motion.getY() < -0.13f ? -0.05f / motion.getY() : 1.0f;
        ((Entity)this.vehicle).setMotion(Vector3f.from(motion.getX() * mul, -0.05f, motion.getZ() * mul));
    }

    protected void onBubbleColumnCollision(boolean drag) {
        Vector3f motion = ((Entity)this.vehicle).getMotion();
        ((Entity)this.vehicle).setMotion(Vector3f.from(motion.getX(), drag ? Math.max(-0.3f, motion.getY() - 0.03f) : Math.min(0.7f, motion.getY() + 0.06f), motion.getZ()));
    }

    protected boolean travel(VehicleContext ctx, float speed) {
        Vector3f movementMultiplier;
        Vector3f motion = ((Entity)this.vehicle).getMotion();
        motion = Vector3f.from(Math.abs(motion.getX()) < 0.003f ? 0.0f : motion.getX(), Math.abs(motion.getY()) < 0.003f ? 0.0f : motion.getY(), Math.abs(motion.getZ()) < 0.003f ? 0.0f : motion.getZ());
        Vector3f lastRotation = ((Entity)this.vehicle).getBedrockRotation();
        this.updateRotation();
        Vector2f playerInput = ((Entity)this.vehicle).getSession().getPlayerEntity().getVehicleInput();
        Vector3f riddenInput = ((ClientVehicle)this.vehicle).getRiddenInput(playerInput.mul(0.98f));
        if (((LivingEntity)this.vehicle).isAlive()) {
            motion = motion.add(this.getInputVector(ctx, speed, riddenInput));
        }
        if ((movementMultiplier = this.getBlockMovementMultiplier(ctx)) != null) {
            motion = motion.mul(movementMultiplier);
        }
        Vector3d correctedMovement = ((Entity)this.vehicle).getSession().getWorldBorder().correctMovement(this.boundingBox, motion.toDouble());
        correctedMovement = ((Entity)this.vehicle).getSession().getCollisionManager().correctMovement(correctedMovement, this.boundingBox, ((Entity)this.vehicle).isOnGround(), this.stepHeight, true, ((ClientVehicle)this.vehicle).canWalkOnLava());
        this.boundingBox.translate(correctedMovement);
        ctx.loadSurroundingBlocks();
        Vector3d moveDiff = motion.toDouble().sub(correctedMovement);
        ((Entity)this.vehicle).setOnGround(moveDiff.getY() != 0.0 && motion.getY() < 0.0f);
        boolean horizontalCollision = moveDiff.getX() != 0.0 || moveDiff.getZ() != 0.0;
        boolean bounced = false;
        if (((Entity)this.vehicle).isOnGround()) {
            Block landingBlock = this.getLandingBlock(ctx).block();
            if (landingBlock == Blocks.SLIME_BLOCK) {
                motion = Vector3f.from(motion.getX(), -motion.getY(), motion.getZ());
                bounced = true;
                float absY = Math.abs(motion.getY());
                if (absY < 0.1f) {
                    float mul = 0.4f + absY * 0.2f;
                    motion = motion.mul(mul, 1.0f, mul);
                }
            } else if (landingBlock instanceof BedBlock) {
                motion = Vector3f.from(motion.getX(), -motion.getY() * 0.66f, motion.getZ());
                bounced = true;
            }
        }
        motion = movementMultiplier != null ? Vector3f.ZERO : motion.mul(moveDiff.getX() == 0.0 ? 1.0f : 0.0f, moveDiff.getY() == 0.0 || bounced ? 1.0f : 0.0f, moveDiff.getZ() == 0.0 ? 1.0f : 0.0f);
        this.moveVehicle(ctx.centerPos(), lastRotation);
        ((Entity)this.vehicle).setMotion(motion);
        this.applyBlockCollisionEffects(ctx);
        float velocityMultiplier = this.getVelocityMultiplier(ctx);
        ((Entity)this.vehicle).setMotion(((Entity)this.vehicle).getMotion().mul(velocityMultiplier, 1.0f, velocityMultiplier));
        return horizontalCollision;
    }

    protected boolean isClimbing(VehicleContext ctx) {
        if (!((ClientVehicle)this.vehicle).canClimb()) {
            return false;
        }
        BlockState blockState = ctx.centerBlock();
        if (blockState.block().is(((Entity)this.vehicle).getSession(), BlockTag.CLIMBABLE)) {
            return true;
        }
        if (blockState.block() instanceof TrapDoorBlock && blockState.getValue(Properties.OPEN).booleanValue()) {
            BlockState ladderState = ctx.getBlock(ctx.centerPos().toInt().down());
            return ladderState.is(Blocks.LADDER) && ladderState.getValue(Properties.HORIZONTAL_FACING) == blockState.getValue(Properties.HORIZONTAL_FACING);
        }
        return false;
    }

    protected Vector3f getInputVector(VehicleContext ctx, float speed, Vector3f input) {
        double lenSquared = input.lengthSquared();
        if (lenSquared < 1.0E-7) {
            return Vector3f.ZERO;
        }
        if (lenSquared > 1.0) {
            input = input.normalize();
        }
        input = input.mul(speed);
        float yaw = ((Entity)this.vehicle).getYaw();
        float sin = TrigMath.sin((double)yaw * (Math.PI / 180));
        float cos = TrigMath.cos((double)yaw * (Math.PI / 180));
        return Vector3f.from(input.getX() * cos - input.getZ() * sin, input.getY(), input.getZ() * cos + input.getX() * sin);
    }

    protected Vector2f getRiddenRotation() {
        SessionPlayerEntity player = ((Entity)this.vehicle).getSession().getPlayerEntity();
        return Vector2f.from(player.getYaw(), player.getPitch() * 0.5f);
    }

    protected void moveVehicle(Vector3d javaPos, Vector3f lastRotation) {
        Vector3f bedrockPos = javaPos.toFloat();
        MoveEntityDeltaPacket moveEntityDeltaPacket = new MoveEntityDeltaPacket();
        moveEntityDeltaPacket.setRuntimeEntityId(((Entity)this.vehicle).getGeyserId());
        if (((Entity)this.vehicle).isOnGround()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        if (((Entity)this.vehicle).getPosition().getX() != bedrockPos.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityDeltaPacket.setX(bedrockPos.getX());
        }
        if (((Entity)this.vehicle).getPosition().getY() != bedrockPos.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityDeltaPacket.setY(bedrockPos.getY());
        }
        if (((Entity)this.vehicle).getPosition().getZ() != bedrockPos.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityDeltaPacket.setZ(bedrockPos.getZ());
        }
        ((Entity)this.vehicle).setPosition(bedrockPos);
        if (((Entity)this.vehicle).getPitch() != lastRotation.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            moveEntityDeltaPacket.setPitch(((Entity)this.vehicle).getPitch());
        }
        if (((Entity)this.vehicle).getYaw() != lastRotation.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityDeltaPacket.setYaw(((Entity)this.vehicle).getYaw());
        }
        if (((Entity)this.vehicle).getHeadYaw() != lastRotation.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            moveEntityDeltaPacket.setHeadYaw(((Entity)this.vehicle).getHeadYaw());
        }
        if (!moveEntityDeltaPacket.getFlags().isEmpty()) {
            ((Entity)this.vehicle).getSession().sendUpstreamPacket(moveEntityDeltaPacket);
        }
        ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(javaPos, ((Entity)this.vehicle).getYaw(), ((Entity)this.vehicle).getPitch(), ((Entity)this.vehicle).isOnGround());
        ((Entity)this.vehicle).getSession().sendDownstreamPacket(moveVehiclePacket);
    }

    protected double getGravity() {
        if (!((Entity)this.vehicle).getFlag(EntityFlag.HAS_GRAVITY)) {
            return 0.0;
        }
        if (((Entity)this.vehicle).getMotion().getY() <= 0.0f && this.effectSlowFalling) {
            return Math.min(0.01, this.gravity);
        }
        return this.gravity;
    }

    private @Nullable Vector3i getSupportingBlockPos(VehicleContext ctx) {
        Vector3i result = null;
        if (((Entity)this.vehicle).isOnGround()) {
            BoundingBox box = this.boundingBox.clone();
            box.extend(0.0, -1.0E-6, 0.0);
            Vector3i min2 = box.getMin().toInt();
            Vector3i max = box.getMax().toInt();
            BlockPositionIterator iter = BlockPositionIterator.fromMinMax(min2.getX(), min2.getY(), min2.getZ(), max.getX(), min2.getY(), max.getZ());
            double minDistance = Double.MAX_VALUE;
            iter.reset();
            while (iter.hasNext()) {
                double distance;
                Vector3i blockPos = Vector3i.from(iter.getX(), iter.getY(), iter.getZ());
                int blockId = ctx.getBlockId(iter);
                BlockCollision blockCollision = ((ClientVehicle)this.vehicle).canWalkOnLava() ? ((Entity)this.vehicle).getSession().getCollisionManager().getCollisionLavaWalking(blockId, blockPos.getY(), this.boundingBox) : BlockUtils.getCollision(blockId);
                if (blockCollision != null && blockCollision.checkIntersection(blockPos, box) && (distance = ctx.centerPos().distanceSquared(blockPos.toDouble().add(0.5f, 0.5f, 0.5f))) <= minDistance) {
                    minDistance = distance;
                    result = blockPos;
                }
                iter.next();
            }
        }
        return result;
    }

    protected BlockState getBlockUnderSupport(VehicleContext ctx, float dist) {
        Vector3i supportingBlockPos = ctx.supportingBlockPos();
        Vector3i blockPos = supportingBlockPos != null ? Vector3i.from((double)supportingBlockPos.getX(), Math.floor(ctx.centerPos().getY() - (double)dist), (double)supportingBlockPos.getZ()) : ctx.centerPos().sub(0.0f, dist, 0.0f).toInt();
        return ctx.getBlock(blockPos);
    }

    protected BlockState getLandingBlock(VehicleContext ctx) {
        return this.getBlockUnderSupport(ctx, 0.2f);
    }

    protected BlockState getVelocityBlock(VehicleContext ctx) {
        return this.getBlockUnderSupport(ctx, 0.500001f);
    }

    protected float getVelocityMultiplier(VehicleContext ctx) {
        Block block = ctx.centerBlock().block();
        if (block == Blocks.WATER || block == Blocks.BUBBLE_COLUMN) {
            return 1.0f;
        }
        if (block == Blocks.SOUL_SAND || block == Blocks.HONEY_BLOCK) {
            return 0.4f;
        }
        block = this.getVelocityBlock(ctx).block();
        if (block == Blocks.SOUL_SAND || block == Blocks.HONEY_BLOCK) {
            return 0.4f;
        }
        return 1.0f;
    }

    protected float getJumpVelocityMultiplier(VehicleContext ctx) {
        Block block = ctx.centerBlock().block();
        if (block == Blocks.HONEY_BLOCK) {
            return 0.5f;
        }
        block = this.getVelocityBlock(ctx).block();
        if (block == Blocks.HONEY_BLOCK) {
            return 0.5f;
        }
        return 1.0f;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setMoveSpeed(float moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    public double getWaterMovementEfficiency() {
        return this.waterMovementEfficiency;
    }

    public void setWaterMovementEfficiency(double waterMovementEfficiency) {
        this.waterMovementEfficiency = waterMovementEfficiency;
    }

    protected class VehicleContext {
        private Vector3d centerPos;
        private Vector3d cachePos;
        private BlockState centerBlock;
        private Vector3i supportingBlockPos;
        private BlockPositionIterator blockIter;
        private int[] blocks;

        protected VehicleContext() {
        }

        protected void loadSurroundingBlocks() {
            this.centerPos = VehicleComponent.this.boundingBox.getBottomCenter();
            if (this.cachePos == null || this.cachePos.distanceSquared(this.centerPos) > 1.0) {
                BoundingBox box = VehicleComponent.this.boundingBox.clone();
                box.expand(2.0);
                Vector3i min2 = box.getMin().toInt();
                Vector3i max = box.getMax().toInt();
                this.blockIter = BlockPositionIterator.fromMinMax(min2.getX(), min2.getY(), min2.getZ(), max.getX(), max.getY(), max.getZ());
                this.blocks = ((Entity)VehicleComponent.this.vehicle).getSession().getGeyser().getWorldManager().getBlocksAt(((Entity)VehicleComponent.this.vehicle).getSession(), this.blockIter);
                this.cachePos = this.centerPos;
            }
            this.centerBlock = this.getBlock(this.centerPos.toInt());
            this.supportingBlockPos = null;
        }

        protected Vector3d centerPos() {
            return this.centerPos;
        }

        protected BlockState centerBlock() {
            return this.centerBlock;
        }

        protected Vector3i supportingBlockPos() {
            if (this.supportingBlockPos == null) {
                this.supportingBlockPos = VehicleComponent.this.getSupportingBlockPos(this);
            }
            return this.supportingBlockPos;
        }

        protected int getBlockId(int x, int y, int z) {
            int index = this.blockIter.getIndex(x, y, z);
            if (index == -1) {
                ((Entity)VehicleComponent.this.vehicle).getSession().getGeyser().getLogger().debug("[client-vehicle] Block cache miss");
                return ((Entity)VehicleComponent.this.vehicle).getSession().getGeyser().getWorldManager().getBlockAt(((Entity)VehicleComponent.this.vehicle).getSession(), x, y, z);
            }
            return this.blocks[index];
        }

        protected int getBlockId(Vector3i pos) {
            return this.getBlockId(pos.getX(), pos.getY(), pos.getZ());
        }

        protected int getBlockId(BlockPositionIterator iter) {
            return this.getBlockId(iter.getX(), iter.getY(), iter.getZ());
        }

        protected BlockState getBlock(int x, int y, int z) {
            return BlockState.of(this.getBlockId(x, y, z));
        }

        protected BlockState getBlock(Vector3i pos) {
            return BlockState.of(this.getBlockId(pos.getX(), pos.getY(), pos.getZ()));
        }

        protected BlockState getBlock(BlockPositionIterator iter) {
            return BlockState.of(this.getBlockId(iter.getX(), iter.getY(), iter.getZ()));
        }
    }
}

