/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.Direction;

public class BoundingBox
implements Cloneable {
    private static final double EPSILON = 1.0E-7;
    private double middleX;
    private double middleY;
    private double middleZ;
    private double sizeX;
    private double sizeY;
    private double sizeZ;

    public BoundingBox(Vector3d position, double sizeX, double sizeY, double sizeZ) {
        this.middleX = position.getX();
        this.middleY = position.getY();
        this.middleZ = position.getZ();
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void translate(double x, double y, double z) {
        this.middleX += x;
        this.middleY += y;
        this.middleZ += z;
    }

    public void extend(double x, double y, double z) {
        this.middleX += x / 2.0;
        this.middleY += y / 2.0;
        this.middleZ += z / 2.0;
        this.sizeX += Math.abs(x);
        this.sizeY += Math.abs(y);
        this.sizeZ += Math.abs(z);
    }

    public void expand(double x, double y, double z) {
        this.sizeX += x;
        this.sizeY += y;
        this.sizeZ += z;
    }

    public void translate(Vector3d translate) {
        this.translate(translate.getX(), translate.getY(), translate.getZ());
    }

    public void extend(Vector3d extend) {
        this.extend(extend.getX(), extend.getY(), extend.getZ());
    }

    public void expand(double expand) {
        this.expand(expand, expand, expand);
    }

    public boolean checkIntersection(double offsetX, double offsetY, double offsetZ, BoundingBox otherBox) {
        return Math.abs(this.middleX + offsetX - otherBox.getMiddleX()) * 2.0 < this.sizeX + otherBox.getSizeX() && Math.abs(this.middleY + offsetY - otherBox.getMiddleY()) * 2.0 < this.sizeY + otherBox.getSizeY() && Math.abs(this.middleZ + offsetZ - otherBox.getMiddleZ()) * 2.0 < this.sizeZ + otherBox.getSizeZ();
    }

    public boolean checkIntersection(Vector3d offset, BoundingBox otherBox) {
        return this.checkIntersection(offset.getX(), offset.getY(), offset.getZ(), otherBox);
    }

    public boolean checkIntersection(BoundingBox otherBox) {
        return this.checkIntersection(0.0, 0.0, 0.0, otherBox);
    }

    public Vector3d getMin() {
        double x = this.middleX - this.sizeX / 2.0;
        double y = this.middleY - this.sizeY / 2.0;
        double z = this.middleZ - this.sizeZ / 2.0;
        return Vector3d.from(x, y, z);
    }

    public double getMin(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.middleX - this.sizeX / 2.0;
            case Axis.Y -> this.middleY - this.sizeY / 2.0;
            case Axis.Z -> this.middleZ - this.sizeZ / 2.0;
        };
    }

    public Vector3d getMax() {
        double x = this.middleX + this.sizeX / 2.0;
        double y = this.middleY + this.sizeY / 2.0;
        double z = this.middleZ + this.sizeZ / 2.0;
        return Vector3d.from(x, y, z);
    }

    public double getMax(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.middleX + this.sizeX / 2.0;
            case Axis.Y -> this.middleY + this.sizeY / 2.0;
            case Axis.Z -> this.middleZ + this.sizeZ / 2.0;
        };
    }

    public Vector3d getBottomCenter() {
        return Vector3d.from(this.middleX, this.middleY - this.sizeY / 2.0, this.middleZ);
    }

    private boolean checkOverlapInAxis(double xOffset, double yOffset, double zOffset, BoundingBox otherBox, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (this.sizeX + otherBox.getSizeX() - Math.abs(this.middleX + xOffset - otherBox.getMiddleX()) * 2.0 > 1.0E-7) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (this.sizeY + otherBox.getSizeY() - Math.abs(this.middleY + yOffset - otherBox.getMiddleY()) * 2.0 > 1.0E-7) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> this.sizeZ + otherBox.getSizeZ() - Math.abs(this.middleZ + zOffset - otherBox.getMiddleZ()) * 2.0 > 1.0E-7;
        };
    }

    public double getMaxOffset(double xOffset, double yOffset, double zOffset, BoundingBox otherBoundingBox, Axis axis, double offset) {
        double max;
        double min2;
        for (Axis a : Axis.VALUES) {
            if (a == axis || this.checkOverlapInAxis(xOffset, yOffset, zOffset, otherBoundingBox, a)) continue;
            return offset;
        }
        if (offset > 0.0) {
            double max2;
            double min3 = axis.choose(this.getMin().add(xOffset, yOffset, zOffset));
            if (min3 - (max2 = axis.choose(otherBoundingBox.getMax())) >= -2.0E-5) {
                offset = Math.min(min3 - max2, offset);
            }
        } else if (offset < 0.0 && (min2 = axis.choose(otherBoundingBox.getMin())) - (max = axis.choose(this.getMax().add(xOffset, yOffset, zOffset))) >= -2.0E-5) {
            offset = Math.max(max - min2, offset);
        }
        return offset;
    }

    public double getIntersectionSize(BoundingBox otherBoundingBox, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.getMax().getY() - otherBoundingBox.getMin().getY();
            case Direction.UP -> otherBoundingBox.getMax().getY() - this.getMin().getY();
            case Direction.NORTH -> this.getMax().getZ() - otherBoundingBox.getMin().getZ();
            case Direction.SOUTH -> otherBoundingBox.getMax().getZ() - this.getMin().getZ();
            case Direction.WEST -> this.getMax().getX() - otherBoundingBox.getMin().getX();
            case Direction.EAST -> otherBoundingBox.getMax().getX() - this.getMin().getX();
        };
    }

    public BoundingBox clone() {
        BoundingBox clone = (BoundingBox)super.clone();
        clone.middleX = this.middleX;
        clone.middleY = this.middleY;
        clone.middleZ = this.middleZ;
        clone.sizeX = this.sizeX;
        clone.sizeY = this.sizeY;
        clone.sizeZ = this.sizeZ;
        return clone;
    }

    public double getMiddleX() {
        return this.middleX;
    }

    public double getMiddleY() {
        return this.middleY;
    }

    public double getMiddleZ() {
        return this.middleZ;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public double getSizeZ() {
        return this.sizeZ;
    }

    public void setMiddleX(double middleX) {
        this.middleX = middleX;
    }

    public void setMiddleY(double middleY) {
        this.middleY = middleY;
    }

    public void setMiddleZ(double middleZ) {
        this.middleZ = middleZ;
    }

    public void setSizeX(double sizeX) {
        this.sizeX = sizeX;
    }

    public void setSizeY(double sizeY) {
        this.sizeY = sizeY;
    }

    public void setSizeZ(double sizeZ) {
        this.sizeZ = sizeZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMiddleX(), other.getMiddleX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMiddleY(), other.getMiddleY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMiddleZ(), other.getMiddleZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getSizeX(), other.getSizeX()) != 0) {
            return false;
        }
        if (Double.compare(this.getSizeY(), other.getSizeY()) != 0) {
            return false;
        }
        return Double.compare(this.getSizeZ(), other.getSizeZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundingBox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $middleX = Double.doubleToLongBits(this.getMiddleX());
        result = result * 59 + (int)($middleX >>> 32 ^ $middleX);
        long $middleY = Double.doubleToLongBits(this.getMiddleY());
        result = result * 59 + (int)($middleY >>> 32 ^ $middleY);
        long $middleZ = Double.doubleToLongBits(this.getMiddleZ());
        result = result * 59 + (int)($middleZ >>> 32 ^ $middleZ);
        long $sizeX = Double.doubleToLongBits(this.getSizeX());
        result = result * 59 + (int)($sizeX >>> 32 ^ $sizeX);
        long $sizeY = Double.doubleToLongBits(this.getSizeY());
        result = result * 59 + (int)($sizeY >>> 32 ^ $sizeY);
        long $sizeZ = Double.doubleToLongBits(this.getSizeZ());
        result = result * 59 + (int)($sizeZ >>> 32 ^ $sizeZ);
        return result;
    }

    public String toString() {
        return "BoundingBox(middleX=" + this.getMiddleX() + ", middleY=" + this.getMiddleY() + ", middleZ=" + this.getMiddleZ() + ", sizeX=" + this.getSizeX() + ", sizeY=" + this.getSizeY() + ", sizeZ=" + this.getSizeZ() + ")";
    }

    public BoundingBox(double middleX, double middleY, double middleZ, double sizeX, double sizeY, double sizeZ) {
        this.middleX = middleX;
        this.middleY = middleY;
        this.middleZ = middleZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }
}

