/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureBlockType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureEditorData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.StructureBlockUpdatePacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.StructureBlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockMode;

@Translator(packet=StructureBlockUpdatePacket.class)
public class BedrockStructureBlockUpdateTranslator
extends PacketTranslator<StructureBlockUpdatePacket> {
    @Override
    public void translate(GeyserSession session, StructureBlockUpdatePacket packet) {
        StructureEditorData data = packet.getEditorData();
        UpdateStructureBlockAction action = UpdateStructureBlockAction.UPDATE_DATA;
        if (packet.isPowered()) {
            if (data.getType() == StructureBlockType.LOAD) {
                action = UpdateStructureBlockAction.LOAD_STRUCTURE;
            } else if (data.getType() == StructureBlockType.SAVE) {
                action = UpdateStructureBlockAction.SAVE_STRUCTURE;
            }
        }
        UpdateStructureBlockMode mode = switch (data.getType()) {
            case StructureBlockType.CORNER -> UpdateStructureBlockMode.CORNER;
            case StructureBlockType.DATA -> UpdateStructureBlockMode.DATA;
            case StructureBlockType.LOAD -> UpdateStructureBlockMode.LOAD;
            default -> UpdateStructureBlockMode.SAVE;
        };
        StructureBlockUtils.sendJavaStructurePacket(session, packet.getBlockPosition(), data.getSettings().getSize(), mode, action, data.getSettings(), data.isBoundingBoxVisible(), data.getName());
        session.getStructureBlockCache().clear();
    }
}

