/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.backendbound;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.geysermc.erosion.packet.ProtocolUtils;
import org.geysermc.erosion.packet.backendbound.BackendboundPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPacketHandler;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public final class BackendboundInitializePacket
implements BackendboundPacket {
    private final UUID uuid;
    private final int javaProtocolVersion;

    public BackendboundInitializePacket(UUID uuid, int javaProtocolVersion) {
        this.uuid = uuid;
        this.javaProtocolVersion = javaProtocolVersion;
    }

    public BackendboundInitializePacket(ByteBuf buf) {
        this.uuid = ProtocolUtils.readUuid(buf);
        this.javaProtocolVersion = VarInts.readUnsignedInt(buf);
    }

    @Override
    public void serialize(ByteBuf buf) {
        ProtocolUtils.writeUuid(buf, this.uuid);
        VarInts.writeUnsignedInt(buf, this.javaProtocolVersion);
    }

    @Override
    public void handle(BackendboundPacketHandler packetHandler) {
        packetHandler.handleInitialization(this);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getJavaProtocolVersion() {
        return this.javaProtocolVersion;
    }

    public String toString() {
        return "BackendboundInitializePacket{uuid=" + String.valueOf(this.uuid) + ", javaProtocolVersion=" + this.javaProtocolVersion + "}";
    }
}

