/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.farm;

import java.util.Locale;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.living.animal.VariantHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.RegistryCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;

public abstract class TemperatureVariantAnimal
extends AnimalEntity
implements VariantHolder<BuiltInVariant> {
    public static final RegistryCache.RegistryReader<BuiltInVariant> VARIANT_READER = VariantHolder.reader(BuiltInVariant.class, BuiltInVariant.TEMPERATE);

    public TemperatureVariantAnimal(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        this.propertyManager.add("minecraft:climate_variant", "temperate");
        this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
    }

    @Override
    public void setBedrockVariant(BuiltInVariant variant) {
        this.propertyManager.add("minecraft:climate_variant", variant.toBedrock());
        this.updateBedrockEntityProperties();
    }

    public static enum BuiltInVariant implements VariantHolder.BuiltIn
    {
        COLD,
        TEMPERATE,
        WARM;


        public String toBedrock() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

