/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.fasterxml.jackson.databind.JsonNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.registry.type.ParticleMapping;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType;

public class ParticleTypesRegistryLoader
extends EffectRegistryLoader<Map<ParticleType, ParticleMapping>> {
    @Override
    public Map<ParticleType, ParticleMapping> load(String input) {
        this.loadFile(input);
        Iterator particlesIterator = this.get(input).fields();
        Object2ObjectOpenHashMap particles = new Object2ObjectOpenHashMap();
        try {
            while (particlesIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)particlesIterator.next();
                String key = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
                JsonNode bedrockId = ((JsonNode)entry.getValue()).get("bedrockId");
                JsonNode eventType = ((JsonNode)entry.getValue()).get("eventType");
                if (eventType == null && bedrockId == null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping particle mapping " + key + " because no Bedrock equivalent exists.");
                    continue;
                }
                Enum type = null;
                if (eventType != null) {
                    try {
                        type = org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ParticleType.valueOf(eventType.asText().toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ex) {
                        type = LevelEvent.valueOf(eventType.asText().toUpperCase(Locale.ROOT));
                    }
                }
                particles.put(ParticleType.valueOf(key), new ParticleMapping((LevelEventType)((Object)type), bedrockId == null ? null : bedrockId.asText()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return particles;
    }
}

