/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v594.serializer;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongObjectPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v448.serializer.AvailableCommandsSerializer_v448;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.ChainedSubCommandData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AvailableCommandsPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.LongKeys;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.SequencedHashSet;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class AvailableCommandsSerializer_v594
extends AvailableCommandsSerializer_v448 {
    public AvailableCommandsSerializer_v594(TypeMap<CommandParam> paramTypeMap) {
        super(paramTypeMap);
    }

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, AvailableCommandsPacket packet) {
        SequencedHashSet<String> enumValues = new SequencedHashSet<String>();
        SequencedHashSet<String> subCommandValues = new SequencedHashSet<String>();
        SequencedHashSet<String> postFixes = new SequencedHashSet<String>();
        SequencedHashSet<CommandEnumData> enums = new SequencedHashSet<CommandEnumData>();
        SequencedHashSet<ChainedSubCommandData> subCommandData = new SequencedHashSet<ChainedSubCommandData>();
        SequencedHashSet<CommandEnumData> softEnums = new SequencedHashSet<CommandEnumData>();
        SequencedHashSet enumConstraints = new SequencedHashSet();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                enumValues.addAll(data.getAliases().getValues().keySet());
                enums.add(data.getAliases());
            }
            for (ChainedSubCommandData subcommand : data.getSubcommands()) {
                if (subCommandData.contains(subcommand)) continue;
                subCommandData.add(subcommand);
                for (ChainedSubCommandData.Value value2 : subcommand.getValues()) {
                    if (subCommandValues.contains(value2.getFirst())) {
                        subCommandValues.add(value2.getFirst());
                    }
                    if (!subCommandValues.contains(value2.getSecond())) continue;
                    subCommandValues.add(value2.getSecond());
                }
            }
            for (CommandOverloadData overload : data.getOverloads()) {
                for (CommandParamData parameter : overload.getOverloads()) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnums.add(commandEnumData);
                        } else {
                            enums.add(commandEnumData);
                            int enumIndex = enums.indexOf(commandEnumData);
                            commandEnumData.getValues().forEach((key, constraints) -> {
                                enumValues.add((String)key);
                                if (!constraints.isEmpty()) {
                                    int valueIndex = enumValues.indexOf(key);
                                    enumConstraints.add(LongObjectPair.of((long)LongKeys.key(valueIndex, enumIndex), (Object)constraints));
                                }
                            });
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postFixes.add(postfix);
                }
            }
        }
        helper.writeArray(buffer, enumValues, helper::writeString);
        helper.writeArray(buffer, subCommandValues, helper::writeString);
        helper.writeArray(buffer, postFixes, helper::writeString);
        this.writeEnums(buffer, helper, enumValues, enums);
        helper.writeArray(buffer, subCommandData, (buf, value) -> this.writeSubCommand(buffer, helper, (List<String>)subCommandValues, (ChainedSubCommandData)value));
        helper.writeArray(buffer, packet.getCommands(), (buf, command) -> this.writeCommand(buffer, helper, (CommandData)command, (List<CommandEnumData>)enums, (List<CommandEnumData>)softEnums, (List<String>)postFixes, (List<ChainedSubCommandData>)subCommandData));
        helper.writeArray(buffer, softEnums, helper::writeCommandEnum);
        helper.writeArray(buffer, enumConstraints, this::writeEnumConstraint);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, AvailableCommandsPacket packet) {
        SequencedHashSet<String> enumValues = new SequencedHashSet<String>();
        SequencedHashSet subCommandValues = new SequencedHashSet();
        SequencedHashSet postFixes = new SequencedHashSet();
        SequencedHashSet<CommandEnumData> enums = new SequencedHashSet<CommandEnumData>();
        SequencedHashSet subCommandData = new SequencedHashSet();
        SequencedHashSet softEnums = new SequencedHashSet();
        HashSet softEnumParameters = new HashSet();
        helper.readArray(buffer, enumValues, helper::readString);
        helper.readArray(buffer, subCommandValues, helper::readString);
        helper.readArray(buffer, postFixes, helper::readString);
        this.readEnums(buffer, helper, enumValues, enums);
        helper.readArray(buffer, subCommandData, (buf, hel) -> this.readSubCommand((ByteBuf)buf, (BedrockCodecHelper)hel, subCommandValues));
        helper.readArray(buffer, packet.getCommands(), (buf, aHelper) -> this.readCommand((ByteBuf)buf, (BedrockCodecHelper)aHelper, (List<CommandEnumData>)enums, postFixes, softEnumParameters, subCommandData));
        helper.readArray(buffer, softEnums, buf -> helper.readCommandEnum(buffer, true));
        this.readConstraints(buffer, helper, enums, enumValues);
        softEnumParameters.forEach(consumer -> consumer.accept(softEnums));
    }

    protected void writeCommand(ByteBuf buffer, BedrockCodecHelper helper, CommandData commandData, List<CommandEnumData> enums, List<CommandEnumData> softEnums, List<String> postFixes, List<ChainedSubCommandData> subCommands) {
        helper.writeString(buffer, commandData.getName());
        helper.writeString(buffer, commandData.getDescription());
        this.writeFlags(buffer, commandData.getFlags());
        CommandPermission permission = commandData.getPermission() == null ? CommandPermission.ANY : commandData.getPermission();
        buffer.writeByte(permission.ordinal());
        CommandEnumData aliases = commandData.getAliases();
        buffer.writeIntLE(aliases == null ? -1 : enums.indexOf(aliases));
        helper.writeArray(buffer, commandData.getSubcommands(), (buf, subcommand) -> {
            int index = subCommands.indexOf(subcommand);
            Preconditions.checkArgument(index > -1, "Invalid subcommand index: " + subcommand);
            buf.writeShortLE(index);
        });
        CommandOverloadData[] overloads = commandData.getOverloads();
        VarInts.writeUnsignedInt(buffer, overloads.length);
        for (CommandOverloadData overload : overloads) {
            buffer.writeBoolean(overload.isChaining());
            VarInts.writeUnsignedInt(buffer, overload.getOverloads().length);
            for (CommandParamData param : overload.getOverloads()) {
                this.writeParameter(buffer, helper, param, enums, softEnums, postFixes);
            }
        }
    }

    protected CommandData readCommand(ByteBuf buffer, BedrockCodecHelper helper, List<CommandEnumData> enums, List<String> postfixes, Set<Consumer<List<CommandEnumData>>> softEnumParameters, List<ChainedSubCommandData> subCommandsList) {
        String name = helper.readString(buffer);
        String description = helper.readString(buffer);
        Set<CommandData.Flag> flags = this.readFlags(buffer);
        CommandPermission permissions = PERMISSIONS[buffer.readUnsignedByte()];
        int aliasIndex = buffer.readIntLE();
        CommandEnumData aliases = aliasIndex == -1 ? null : enums.get(aliasIndex);
        ObjectArrayList subcommands = new ObjectArrayList();
        helper.readArray(buffer, subcommands, (buf, help) -> {
            int index = buf.readUnsignedShortLE();
            return (ChainedSubCommandData)subCommandsList.get(index);
        });
        CommandOverloadData[] overloads = new CommandOverloadData[VarInts.readUnsignedInt(buffer)];
        for (int i = 0; i < overloads.length; ++i) {
            boolean chaining = buffer.readBoolean();
            CommandParamData[] params = new CommandParamData[VarInts.readUnsignedInt(buffer)];
            overloads[i] = new CommandOverloadData(chaining, params);
            for (int i2 = 0; i2 < params.length; ++i2) {
                params[i2] = this.readParameter(buffer, helper, enums, postfixes, softEnumParameters);
            }
        }
        return new CommandData(name, description, flags, permissions, aliases, (List<ChainedSubCommandData>)subcommands, overloads);
    }

    protected void writeSubCommand(ByteBuf buffer, BedrockCodecHelper helper, List<String> values, ChainedSubCommandData data) {
        helper.writeString(buffer, data.getName());
        helper.writeArray(buffer, data.getValues(), (buf, val) -> {
            int first = values.indexOf(val.getFirst());
            Preconditions.checkArgument(first > -1, "Invalid enum value detected: " + val.getFirst());
            int second = values.indexOf(val.getSecond());
            Preconditions.checkArgument(second > -1, "Invalid enum value detected: " + val.getSecond());
            buf.writeShortLE(first);
            buf.writeShortLE(second);
        });
    }

    protected ChainedSubCommandData readSubCommand(ByteBuf buffer, BedrockCodecHelper helper, List<String> values) {
        String name = helper.readString(buffer);
        ChainedSubCommandData data = new ChainedSubCommandData(name);
        helper.readArray(buffer, data.getValues(), buf -> {
            int first = buf.readUnsignedShortLE();
            int second = buf.readUnsignedShortLE();
            return new ChainedSubCommandData.Value((String)values.get(first), (String)values.get(second));
        });
        return data;
    }
}

