/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression;

import io.airlift.compress.snappy.SnappyRawCompressor;
import io.airlift.compress.snappy.SnappyRawDecompressor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression.BatchCompression;
import sun.misc.Unsafe;

public class SnappyCompression
implements BatchCompression {
    private static final ThreadLocal<short[]> TABLE = ThreadLocal.withInitial(() -> new short[16384]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf direct;
        if (!msg.isDirect() || msg instanceof CompositeByteBuf) {
            direct = ctx.alloc().ioBuffer(msg.readableBytes());
            direct.writeBytes(msg);
        } else {
            direct = msg;
        }
        ByteBuf output = ctx.alloc().directBuffer();
        try {
            long outputEndAddress;
            long outputAddress;
            long inputAddress = direct.memoryAddress() + (long)direct.readerIndex();
            long inputEndAddress = inputAddress + (long)direct.readableBytes();
            output.ensureWritable(SnappyRawCompressor.maxCompressedLength((int)direct.readableBytes()));
            byte[] outputArray = null;
            if (output.isDirect() && output.hasMemoryAddress()) {
                outputAddress = output.memoryAddress() + (long)output.writerIndex();
                outputEndAddress = outputAddress + (long)output.writableBytes();
            } else if (output.hasArray()) {
                outputArray = output.array();
                outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.writerIndex();
                outputEndAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.writableBytes();
            } else {
                throw new IllegalStateException("Unsupported ByteBuf " + output.getClass().getSimpleName());
            }
            int compressed = SnappyRawCompressor.compress(null, (long)inputAddress, (long)inputEndAddress, (Object)outputArray, (long)outputAddress, (long)outputEndAddress, (short[])TABLE.get());
            output.writerIndex(output.writerIndex() + compressed);
            ByteBuf byteBuf = output.retain();
            return byteBuf;
        }
        finally {
            output.release();
            if (direct != msg) {
                direct.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf decode(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf direct;
        if (!msg.isDirect() || msg instanceof CompositeByteBuf) {
            direct = ctx.alloc().ioBuffer(msg.readableBytes());
            direct.writeBytes(msg);
        } else {
            direct = msg;
        }
        ByteBuf output = ctx.alloc().directBuffer();
        try {
            long outputEndAddress;
            long outputAddress;
            long inputAddress = direct.memoryAddress() + (long)direct.readerIndex();
            long inputEndAddress = inputAddress + (long)direct.readableBytes();
            output.ensureWritable(SnappyRawDecompressor.getUncompressedLength(null, (long)inputAddress, (long)inputEndAddress));
            byte[] outputArray = null;
            if (output.isDirect() && output.hasMemoryAddress()) {
                outputAddress = output.memoryAddress() + (long)output.writerIndex();
                outputEndAddress = outputAddress + (long)output.writableBytes();
            } else if (output.hasArray()) {
                outputArray = output.array();
                outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.writerIndex();
                outputEndAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.writableBytes();
            } else {
                throw new IllegalStateException("Unsupported ByteBuf " + output.getClass().getSimpleName());
            }
            int decompressed = SnappyRawDecompressor.decompress(null, (long)inputAddress, (long)inputEndAddress, (Object)outputArray, (long)outputAddress, (long)outputEndAddress);
            output.writerIndex(output.writerIndex() + decompressed);
            ByteBuf byteBuf = output.retain();
            return byteBuf;
        }
        finally {
            output.release();
            if (direct != msg) {
                direct.release();
            }
        }
    }

    @Override
    public CompressionAlgorithm getAlgorithm() {
        return PacketCompressionAlgorithm.SNAPPY;
    }

    @Override
    public void setLevel(int level) {
    }

    @Override
    public int getLevel() {
        return -1;
    }
}

