/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.entity.type.ChestBoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;

@Translator(packet=InteractPacket.class)
public class BedrockInteractTranslator
extends PacketTranslator<InteractPacket> {
    @Override
    public void translate(GeyserSession session, InteractPacket packet) {
        Entity entity = packet.getRuntimeEntityId() == session.getPlayerEntity().getGeyserId() ? session.getPlayerEntity() : session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
        if (entity == null) {
            return;
        }
        switch (packet.getAction()) {
            case INTERACT: {
                if (session.getPlayerInventory().getItemInHand().asItem() == Items.SHIELD) break;
                ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamGamePacket(interactPacket);
                break;
            }
            case DAMAGE: {
                ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(entity.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamGamePacket(attackPacket);
                break;
            }
            case LEAVE_VEHICLE: {
                ServerboundPlayerCommandPacket sneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SNEAKING);
                session.sendDownstreamGamePacket(sneakPacket);
                session.setSteeringLeft(false);
                session.setSteeringRight(false);
                Entity currentVehicle = session.getPlayerEntity().getVehicle();
                if (currentVehicle == null) break;
                session.setMountVehicleScheduledFuture(session.scheduleInEventLoop(() -> {
                    if (session.getPlayerEntity().getVehicle() == null) {
                        return;
                    }
                    long vehicleBedrockId = currentVehicle.getGeyserId();
                    if (session.getPlayerEntity().getVehicle().getGeyserId() == vehicleBedrockId) {
                        SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
                        linkPacket.setEntityLink(new EntityLinkData(vehicleBedrockId, session.getPlayerEntity().getGeyserId(), EntityLinkData.Type.PASSENGER, true, false, 0.0f));
                        session.sendUpstreamPacket(linkPacket);
                    }
                }, 1L, TimeUnit.SECONDS));
                break;
            }
            case MOUSEOVER: {
                if (packet.getRuntimeEntityId() != 0L) {
                    Entity interactEntity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
                    session.setMouseoverEntity(interactEntity);
                    if (interactEntity == null) {
                        return;
                    }
                    interactEntity.updateInteractiveTag();
                    break;
                }
                if (session.getMouseoverEntity() == null) break;
                session.setMouseoverEntity(null);
                session.getPlayerEntity().getDirtyMetadata().put(EntityDataTypes.INTERACT_TEXT, "");
                session.getPlayerEntity().updateBedrockMetadata();
                break;
            }
            case OPEN_INVENTORY: {
                if (session.getInventoryHolder() != null) break;
                Entity ridingEntity = session.getPlayerEntity().getVehicle();
                if (ridingEntity instanceof AbstractHorseEntity || ridingEntity instanceof ChestBoatEntity) {
                    ServerboundPlayerCommandPacket openVehicleWindowPacket = new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.OPEN_VEHICLE_INVENTORY);
                    session.sendDownstreamGamePacket(openVehicleWindowPacket);
                    break;
                }
                InventoryUtils.openInventory(session.getPlayerInventoryHolder());
            }
        }
    }
}

