/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.kyori.adventure.key.Key;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannels;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerSpawnInfo;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundLoginPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundPlayerLoadedPacket;

@Translator(packet=ClientboundLoginPacket.class)
public class JavaLoginTranslator
extends PacketTranslator<ClientboundLoginPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginPacket packet) {
        boolean needsSpawnPacket;
        SessionPlayerEntity entity = session.getPlayerEntity();
        entity.setEntityId(packet.getEntityId());
        PlayerSpawnInfo spawnInfo = packet.getCommonPlayerSpawnInfo();
        JavaDimension newDimension = session.getRegistryCache().registry(JavaRegistries.DIMENSION_TYPE).byId(spawnInfo.getDimension());
        if (session.isSpawned()) {
            int fakeDim = DimensionUtils.getTemporaryDimension(session.getBedrockDimension().bedrockId(), newDimension.bedrockId());
            if (fakeDim != newDimension.bedrockId()) {
                DimensionUtils.fastSwitchDimension(session, fakeDim);
            }
            session.getEntityCache().removeAllBossBars();
            entity.resetAttributes();
            entity.resetMetadata();
        }
        session.setDimensionType(newDimension);
        session.setWorldName(spawnInfo.getWorldName());
        session.setLevels((String[])Arrays.stream(packet.getWorldNames()).map(Key::asString).toArray(String[]::new));
        session.setGameMode(spawnInfo.getGameMode());
        boolean bl = needsSpawnPacket = !session.isSentSpawnPacket();
        if (needsSpawnPacket) {
            DimensionUtils.setBedrockDimension(session, newDimension.bedrockId());
            session.connect();
            session.getUpstream().sendPostStartGamePackets();
        } else {
            SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
            playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(spawnInfo.getGameMode()).ordinal());
            session.sendUpstreamPacket(playerGameTypePacket);
        }
        entity.setLastDeathPosition(spawnInfo.getLastDeathPos());
        entity.updateBedrockMetadata();
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", !packet.isEnableRespawnScreen()));
        session.sendUpstreamPacket(gamerulePacket);
        session.setReducedDebugInfo(packet.isReducedDebugInfo());
        session.setServerRenderDistance(packet.getViewDistance());
        session.sendJavaClientSettings();
        Key register = MinecraftKey.key("register");
        if (session.remoteServer().authType() == AuthType.FLOODGATE) {
            session.sendDownstreamPacket(new ServerboundCustomPayloadPacket(register, PluginMessageChannels.getFloodgateRegisterData()));
        }
        session.sendDownstreamPacket(new ServerboundCustomPayloadPacket(register, "erosion:msg".getBytes(StandardCharsets.UTF_8)));
        if (session.getBedrockDimension().bedrockId() != newDimension.bedrockId()) {
            DimensionUtils.switchDimension(session, newDimension);
        } else if (BedrockDimension.isCustomBedrockNetherId() && newDimension.isNetherLike()) {
            session.camera().sendFog("minecraft:fog_hell");
        }
        ChunkUtils.loadDimension(session);
        if (!needsSpawnPacket) {
            session.sendDownstreamGamePacket(ServerboundPlayerLoadedPacket.INSTANCE);
        }
    }
}

